<?php

namespace Usoko\SIGBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * BeneficioPedido
 *
 * @ORM\Table(name="beneficio_pedido", indexes={@ORM\Index(name="fk_Beneficio_Pedido_Tipo_Beneficio1_idx", columns={"Tipo_Beneficio"}), @ORM\Index(name="fk_Beneficio_Pedido_Plano_Pensao1_idx", columns={"Plano_Pensao"})})
 * @ORM\Entity
 */
class BeneficioPedido
{
    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $id;

    /**
     * @var string
     *
     * @ORM\Column(name="codigo", type="string", length=50, nullable=false)
     */
    private $codigo;

    /**
     * @var float
     *
     * @ORM\Column(name="valorMensal", type="float", precision=10, scale=0, nullable=true)
     */
    private $valormensal;

    /**
     * @var string
     *
     * @ORM\Column(name="fPagamento", type="string", length=1, nullable=false)
     */
    private $fpagamento = 'M';

    /**
     * @var string
     *
     * @ORM\Column(name="estado", type="string", length=1, nullable=false)
     */
    private $estado;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="data", type="datetime", nullable=false)
     */
    private $data;

    /**
     * @var string
     *
     * @ORM\Column(name="descricao", type="text", nullable=true)
     */
    private $descricao;

    /**
     * @var string
     *
     * @ORM\Column(name="anexo", type="string", length=150, nullable=true)
     */
    private $anexo;

    /**
     * @var \PlanoPensao
     *
     * @ORM\ManyToOne(targetEntity="PlanoPensao")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="Plano_Pensao", referencedColumnName="id")
     * })
     */
    private $planoPensao;

    /**
     * @var \TipoBeneficio
     *
     * @ORM\ManyToOne(targetEntity="TipoBeneficio")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="Tipo_Beneficio", referencedColumnName="id")
     * })
     */
    private $tipoBeneficio;



    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set codigo
     *
     * @param string $codigo
     * @return BeneficioPedido
     */
    public function setCodigo($codigo)
    {
        $this->codigo = $codigo;

        return $this;
    }

    /**
     * Get codigo
     *
     * @return string 
     */
    public function getCodigo()
    {
        return $this->codigo;
    }

    /**
     * Set valormensal
     *
     * @param float $valormensal
     * @return BeneficioPedido
     */
    public function setValormensal($valormensal)
    {
        $this->valormensal = $valormensal;

        return $this;
    }

    /**
     * Get valormensal
     *
     * @return float 
     */
    public function getValormensal()
    {
        return $this->valormensal;
    }

    /**
     * Set fpagamento
     *
     * @param string $fpagamento
     * @return BeneficioPedido
     */
    public function setFpagamento($fpagamento)
    {
        $this->fpagamento = $fpagamento;

        return $this;
    }

    /**
     * Get fpagamento
     *
     * @return string 
     */
    public function getFpagamento()
    {
        return $this->fpagamento;
    }

    /**
     * Set estado
     *
     * @param string $estado
     * @return BeneficioPedido
     */
    public function setEstado($estado)
    {
        $this->estado = $estado;

        return $this;
    }

    /**
     * Get estado
     *
     * @return string 
     */
    public function getEstado()
    {
        return $this->estado;
    }

    /**
     * Set data
     *
     * @param \DateTime $data
     * @return BeneficioPedido
     */
    public function setData($data)
    {
        $this->data = $data;

        return $this;
    }

    /**
     * Get data
     *
     * @return \DateTime 
     */
    public function getData()
    {
        return $this->data;
    }

    /**
     * Set descricao
     *
     * @param string $descricao
     * @return BeneficioPedido
     */
    public function setDescricao($descricao)
    {
        $this->descricao = $descricao;

        return $this;
    }

    /**
     * Get descricao
     *
     * @return string 
     */
    public function getDescricao()
    {
        return $this->descricao;
    }

    /**
     * Set anexo
     *
     * @param string $anexo
     * @return BeneficioPedido
     */
    public function setAnexo($anexo)
    {
        $this->anexo = $anexo;

        return $this;
    }

    /**
     * Get anexo
     *
     * @return string 
     */
    public function getAnexo()
    {
        return $this->anexo;
    }

    /**
     * Set planoPensao
     *
     * @param \Usoko\SIGBundle\Entity\PlanoPensao $planoPensao
     * @return BeneficioPedido
     */
    public function setPlanoPensao(\Usoko\SIGBundle\Entity\PlanoPensao $planoPensao = null)
    {
        $this->planoPensao = $planoPensao;

        return $this;
    }

    /**
     * Get planoPensao
     *
     * @return \Usoko\SIGBundle\Entity\PlanoPensao 
     */
    public function getPlanoPensao()
    {
        return $this->planoPensao;
    }

    /**
     * Set tipoBeneficio
     *
     * @param \Usoko\SIGBundle\Entity\TipoBeneficio $tipoBeneficio
     * @return BeneficioPedido
     */
    public function setTipoBeneficio(\Usoko\SIGBundle\Entity\TipoBeneficio $tipoBeneficio = null)
    {
        $this->tipoBeneficio = $tipoBeneficio;

        return $this;
    }

    /**
     * Get tipoBeneficio
     *
     * @return \Usoko\SIGBundle\Entity\TipoBeneficio 
     */
    public function getTipoBeneficio()
    {
        return $this->tipoBeneficio;
    }
    
    public function __toString() {
        return $this->getCodigo();
    }
}
