<?php

namespace Usoko\SIGBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * BeneficioResposta
 *
 * @ORM\Table(name="beneficio_resposta", indexes={@ORM\Index(name="fk_Beneficio_Resposta_Beneficio_Pedido1_idx", columns={"Beneficio_Pedido"})})
 * @ORM\Entity
 */
class BeneficioResposta
{
    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $id;

    /**
     * @var string
     *
     * @ORM\Column(name="fPagamento", type="string", length=1, nullable=true)
     */
    private $fpagamento;

    /**
     * @var float
     *
     * @ORM\Column(name="valor_total", type="float", precision=10, scale=0, nullable=true)
     */
    private $valorTotal;

    /**
     * @var float
     *
     * @ORM\Column(name="valor_mensal", type="float", precision=10, scale=0, nullable=true)
     */
    private $valorMensal;

    /**
     * @var string
     *
     * @ORM\Column(name="estado", type="string", length=1, nullable=true)
     */
    private $estado;

    /**
     * @var string
     *
     * @ORM\Column(name="resposta", type="string", length=1, nullable=false)
     */
    private $resposta;

    /**
     * @var string
     *
     * @ORM\Column(name="observacao", type="text", nullable=true)
     */
    private $observacao;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="data", type="datetime", nullable=false)
     */
    private $data;

    /**
     * @var \BeneficioPedido
     *
     * @ORM\ManyToOne(targetEntity="BeneficioPedido")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="Beneficio_Pedido", referencedColumnName="id")
     * })
     */
    private $beneficioPedido;

    /**
     * @var \Doctrine\Common\Collections\Collection
     *
     * @ORM\ManyToMany(targetEntity="Justificacao", mappedBy="beneficioResposta")
     */
    private $justificacao;

    /**
     * Constructor
     */
    public function __construct()
    {
        $this->justificacao = new \Doctrine\Common\Collections\ArrayCollection();
    }


    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set fpagamento
     *
     * @param string $fpagamento
     * @return BeneficioResposta
     */
    public function setFpagamento($fpagamento)
    {
        $this->fpagamento = $fpagamento;

        return $this;
    }

    /**
     * Get fpagamento
     *
     * @return string 
     */
    public function getFpagamento()
    {
        return $this->fpagamento;
    }

    /**
     * Set valorTotal
     *
     * @param float $valorTotal
     * @return BeneficioResposta
     */
    public function setValorTotal($valorTotal)
    {
        $this->valorTotal = $valorTotal;

        return $this;
    }

    /**
     * Get valorTotal
     *
     * @return float 
     */
    public function getValorTotal()
    {
        return $this->valorTotal;
    }

    /**
     * Set valorMensal
     *
     * @param float $valorMensal
     * @return BeneficioResposta
     */
    public function setValorMensal($valorMensal)
    {
        $this->valorMensal = $valorMensal;

        return $this;
    }

    /**
     * Get valorMensal
     *
     * @return float 
     */
    public function getValorMensal()
    {
        return $this->valorMensal;
    }

    /**
     * Set estado
     *
     * @param string $estado
     * @return BeneficioResposta
     */
    public function setEstado($estado)
    {
        $this->estado = $estado;

        return $this;
    }

    /**
     * Get estado
     *
     * @return string 
     */
    public function getEstado()
    {
        return $this->estado;
    }

    /**
     * Set resposta
     *
     * @param string $resposta
     * @return BeneficioResposta
     */
    public function setResposta($resposta)
    {
        $this->resposta = $resposta;

        return $this;
    }

    /**
     * Get resposta
     *
     * @return string 
     */
    public function getResposta()
    {
        return $this->resposta;
    }

    /**
     * Set observacao
     *
     * @param string $observacao
     * @return BeneficioResposta
     */
    public function setObservacao($observacao)
    {
        $this->observacao = $observacao;

        return $this;
    }

    /**
     * Get observacao
     *
     * @return string 
     */
    public function getObservacao()
    {
        return $this->observacao;
    }

    /**
     * Set data
     *
     * @param \DateTime $data
     * @return BeneficioResposta
     */
    public function setData($data)
    {
        $this->data = $data;

        return $this;
    }

    /**
     * Get data
     *
     * @return \DateTime 
     */
    public function getData()
    {
        return $this->data;
    }

    /**
     * Set beneficioPedido
     *
     * @param \Usoko\SIGBundle\Entity\BeneficioPedido $beneficioPedido
     * @return BeneficioResposta
     */
    public function setBeneficioPedido(\Usoko\SIGBundle\Entity\BeneficioPedido $beneficioPedido = null)
    {
        $this->beneficioPedido = $beneficioPedido;

        return $this;
    }

    /**
     * Get beneficioPedido
     *
     * @return \Usoko\SIGBundle\Entity\BeneficioPedido 
     */
    public function getBeneficioPedido()
    {
        return $this->beneficioPedido;
    }

    /**
     * Add justificacao
     *
     * @param \Usoko\SIGBundle\Entity\Justificacao $justificacao
     * @return BeneficioResposta
     */
    public function addJustificacao(\Usoko\SIGBundle\Entity\Justificacao $justificacao)
    {
        $this->justificacao[] = $justificacao;

        return $this;
    }

    /**
     * Remove justificacao
     *
     * @param \Usoko\SIGBundle\Entity\Justificacao $justificacao
     */
    public function removeJustificacao(\Usoko\SIGBundle\Entity\Justificacao $justificacao)
    {
        $this->justificacao->removeElement($justificacao);
    }

    /**
     * Get justificacao
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getJustificacao()
    {
        return $this->justificacao;
    }
    
    public function __toString() {
        return $this->getResposta();
    }
}
