<?php

namespace Usoko\SIGBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * Cartao
 *
 * @ORM\Table(name="cartao", indexes={@ORM\Index(name="fk_Cartao_Associado1_idx", columns={"Associado"}), @ORM\Index(name="fk_Cartao_Utilizador1_idx", columns={"Utilizador"})})
 * @ORM\Entity
 */
class Cartao
{
    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $id;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="data_emissao", type="datetime", nullable=false)
     */
    private $dataEmissao;

    /**
     * @var string
     *
     * @ORM\Column(name="data_expiracao", type="string", length=45, nullable=true)
     */
    private $dataExpiracao;

    /**
     * @var string
     *
     * @ORM\Column(name="estado", type="string", length=1, nullable=false)
     */
    private $estado;

    /**
     * @var \Associado
     *
     * @ORM\ManyToOne(targetEntity="Associado")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="Associado", referencedColumnName="id")
     * })
     */
    private $associado;

    /**
     * @var \Utilizador
     *
     * @ORM\ManyToOne(targetEntity="Utilizador")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="Utilizador", referencedColumnName="id")
     * })
     */
    private $utilizador;



    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set dataEmissao
     *
     * @param \DateTime $dataEmissao
     * @return Cartao
     */
    public function setDataEmissao($dataEmissao)
    {
        $this->dataEmissao = $dataEmissao;

        return $this;
    }

    /**
     * Get dataEmissao
     *
     * @return \DateTime 
     */
    public function getDataEmissao()
    {
        return $this->dataEmissao;
    }

    /**
     * Set dataExpiracao
     *
     * @param string $dataExpiracao
     * @return Cartao
     */
    public function setDataExpiracao($dataExpiracao)
    {
        $this->dataExpiracao = $dataExpiracao;

        return $this;
    }

    /**
     * Get dataExpiracao
     *
     * @return string 
     */
    public function getDataExpiracao()
    {
        return $this->dataExpiracao;
    }

    /**
     * Set estado
     *
     * @param string $estado
     * @return Cartao
     */
    public function setEstado($estado)
    {
        $this->estado = $estado;

        return $this;
    }

    /**
     * Get estado
     *
     * @return string 
     */
    public function getEstado()
    {
        return $this->estado;
    }

    /**
     * Set associado
     *
     * @param \Usoko\SIGBundle\Entity\Associado $associado
     * @return Cartao
     */
    public function setAssociado(\Usoko\SIGBundle\Entity\Associado $associado = null)
    {
        $this->associado = $associado;

        return $this;
    }

    /**
     * Get associado
     *
     * @return \Usoko\SIGBundle\Entity\Associado 
     */
    public function getAssociado()
    {
        return $this->associado;
    }

    /**
     * Set utilizador
     *
     * @param \Usoko\SIGBundle\Entity\Utilizador $utilizador
     * @return Cartao
     */
    public function setUtilizador(\Usoko\SIGBundle\Entity\Utilizador $utilizador = null)
    {
        $this->utilizador = $utilizador;

        return $this;
    }

    /**
     * Get utilizador
     *
     * @return \Usoko\SIGBundle\Entity\Utilizador 
     */
    public function getUtilizador()
    {
        return $this->utilizador;
    }
}
