<?php

namespace Usoko\SIGBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * Comparticipacao
 *
 * @ORM\Table(name="comparticipacao", uniqueConstraints={@ORM\UniqueConstraint(name="codigo", columns={"codigo"})}, indexes={@ORM\Index(name="fk_Comparticipacao_Tipo_de_Apoio1_idx", columns={"Subsidio"}), @ORM\Index(name="fk_Comparticipacao_Associado1_idx", columns={"Associado"}), @ORM\Index(name="fk_Comparticipacao_Utilizador1_idx", columns={"Utilizador"}), @ORM\Index(name="fk_Comparticipacao_Dependente1_idx", columns={"Dependente"}), @ORM\Index(name="fk_Comparticipacao_Moeda1_idx", columns={"Moeda"})})
 * @ORM\Entity
 */
class Comparticipacao {

    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $id;

    /**
     * @var string
     *
     * @ORM\Column(name="urgencia", type="string", length=2, nullable=false)
     */
    private $urgencia;

    /**
     * @var float
     *
     * @ORM\Column(name="valor", type="float", precision=10, scale=0, nullable=false)
     */
    private $valor;

    /**
     * @var string
     *
     * @ORM\Column(name="codigo", type="string", length=10, nullable=false)
     */
    private $codigo;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="data_actual", type="datetime", nullable=true)
     */
    private $dataActual = 'CURRENT_TIMESTAMP';

    /**
     * @var string
     *
     * @ORM\Column(name="anexo", type="string", length=120, nullable=true)
     */
    private $anexo;

    /**
     * @var string
     *
     * @ORM\Column(name="estado", type="string", length=2, nullable=false)
     */
    private $estado = 'P';

    /**
     * @var string
     *
     * @ORM\Column(name="observacao", type="string", length=50, nullable=true)
     */
    private $observacao;

    /**
     * @var \Subsidio
     *
     * @ORM\ManyToOne(targetEntity="Subsidio")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="Subsidio", referencedColumnName="id")
     * })
     */
    private $subsidio;

    /**
     * @var \Associado
     *
     * @ORM\ManyToOne(targetEntity="Associado")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="Associado", referencedColumnName="id")
     * })
     */
    private $associado;

    /**
     * @var \Utilizador
     *
     * @ORM\ManyToOne(targetEntity="Utilizador")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="Utilizador", referencedColumnName="id")
     * })
     */
    private $utilizador;

    /**
     * @var \Dependente
     *
     * @ORM\ManyToOne(targetEntity="Dependente")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="Dependente", referencedColumnName="id")
     * })
     */
    private $dependente;

    /**
     * @var \Moeda
     *
     * @ORM\ManyToOne(targetEntity="Moeda")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="Moeda", referencedColumnName="id")
     * })
     */
    private $moeda;

    public function __toString() {
        return $this->getCodigo();
    }

    /**
     * Get id
     *
     * @return integer 
     */
    public function getId() {
        return $this->id;
    }

    /**
     * Set urgencia
     *
     * @param string $urgencia
     * @return Comparticipacao
     */
    public function setUrgencia($urgencia) {
        $this->urgencia = $urgencia;

        return $this;
    }

    /**
     * Get urgencia
     *
     * @return string 
     */
    public function getUrgencia() {
        return $this->urgencia;
    }

    /**
     * Set valor
     *
     * @param float $valor
     * @return Comparticipacao
     */
    public function setValor($valor) {
        $this->valor = $valor;

        return $this;
    }

    /**
     * Get valor
     *
     * @return float 
     */
    public function getValor() {
        return $this->valor;
    }

        /**
     * Set codigo
     *
     * @param string $codigo
     * @return Comparticipacao
     */
    public function setCodigo($codigo)
    {
        $this->codigo = $codigo;

        return $this;
    }

    /**
     * Get codigo
     *
     * @return string 
     */
    public function getCodigo()
    {
        return $this->codigo;
    }
    
    /**
     * Set dataActual
     *
     * @param \DateTime $dataActual
     * @return Comparticipacao
     */
    public function setDataActual($dataActual) {
        $this->dataActual = $dataActual;

        return $this;
    }

    /**
     * Get dataActual
     *
     * @return \DateTime 
     */
    public function getDataActual() {
        return $this->dataActual;
    }

    /**
     * Set anexo
     *
     * @param string $anexo
     * @return Comparticipacao
     */
    public function setAnexo($anexo) {
        $this->anexo = $anexo;

        return $this;
    }

    /**
     * Get anexo
     *
     * @return string 
     */
    public function getAnexo() {
        return $this->anexo;
    }

    /**
     * Set estado
     *
     * @param string $estado
     * @return Comparticipacao
     */
    public function setEstado($estado) {
        $this->estado = $estado;

        return $this;
    }

    /**
     * Get estado
     *
     * @return string 
     */
    public function getEstado() {
        return $this->estado;
    }

    /**
     * Set observacao
     *
     * @param string $observacao
     * @return Comparticipacao
     */
    public function setObservacao($observacao) {
        $this->observacao = $observacao;

        return $this;
    }

    /**
     * Get observacao
     *
     * @return string 
     */
    public function getObservacao() {
        return $this->observacao;
    }

    /**
     * Set subsidio
     *
     * @param \Usoko\SIGBundle\Entity\Subsidio $subsidio
     * @return Comparticipacao
     */
    public function setSubsidio(\Usoko\SIGBundle\Entity\Subsidio $subsidio = null) {
        $this->subsidio = $subsidio;

        return $this;
    }

    /**
     * Get subsidio
     *
     * @return \Usoko\SIGBundle\Entity\Subsidio 
     */
    public function getSubsidio() {
        return $this->subsidio;
    }

    /**
     * Set associado
     *
     * @param \Usoko\SIGBundle\Entity\Associado $associado
     * @return Comparticipacao
     */
    public function setAssociado(\Usoko\SIGBundle\Entity\Associado $associado = null) {
        $this->associado = $associado;

        return $this;
    }

    /**
     * Get associado
     *
     * @return \Usoko\SIGBundle\Entity\Associado 
     */
    public function getAssociado() {
        return $this->associado;
    }

    /**
     * Set utilizador
     *
     * @param \Usoko\SIGBundle\Entity\Utilizador $utilizador
     * @return Comparticipacao
     */
    public function setUtilizador(\Usoko\SIGBundle\Entity\Utilizador $utilizador = null) {
        $this->utilizador = $utilizador;

        return $this;
    }

    /**
     * Get utilizador
     *
     * @return \Usoko\SIGBundle\Entity\Utilizador 
     */
    public function getUtilizador() {
        return $this->utilizador;
    }

    /**
     * Set dependente
     *
     * @param \Usoko\SIGBundle\Entity\Dependente $dependente
     * @return Comparticipacao
     */
    public function setDependente(\Usoko\SIGBundle\Entity\Dependente $dependente = null) {
        $this->dependente = $dependente;

        return $this;
    }

    /**
     * Get dependente
     *
     * @return \Usoko\SIGBundle\Entity\Dependente 
     */
    public function getDependente() {
        return $this->dependente;
    }

    /**
     * Set moeda
     *
     * @param \Usoko\SIGBundle\Entity\Moeda $moeda
     * @return Comparticipacao
     */
    public function setMoeda(\Usoko\SIGBundle\Entity\Moeda $moeda = null) {
        $this->moeda = $moeda;

        return $this;
    }

    /**
     * Get moeda
     *
     * @return \Usoko\SIGBundle\Entity\Moeda 
     */
    public function getMoeda() {
        return $this->moeda;
    }

}
