<?php

namespace Usoko\SIGBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * ComparticipacaoResposta
 *
 * @ORM\Table(name="comparticipacao_resposta", indexes={@ORM\Index(name="fk_Comparticipacao_resposta_Comparticipação1_idx", columns={"Comparticipacao"}), @ORM\Index(name="fk_Comparticipacao_Resposta_Moeda1_idx", columns={"Moeda"})})
 * @ORM\Entity
 */
class ComparticipacaoResposta
{
    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $id;

    /**
     * @var float
     *
     * @ORM\Column(name="valor", type="float", precision=10, scale=0, nullable=false)
     */
    private $valor;

    /**
     * @var string
     *
     * @ORM\Column(name="resposta", type="string", length=2, nullable=false)
     */
    private $resposta;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="data", type="datetime", nullable=false)
     */
    private $data = 'CURRENT_TIMESTAMP';

    /**
     * @var string
     *
     * @ORM\Column(name="observacao", type="text", nullable=true)
     */
    private $observacao;

    /**
     * @var \Comparticipacao
     *
     * @ORM\ManyToOne(targetEntity="Comparticipacao")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="Comparticipacao", referencedColumnName="id")
     * })
     */
    private $comparticipacao;

    /**
     * @var \Moeda
     *
     * @ORM\ManyToOne(targetEntity="Moeda")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="Moeda", referencedColumnName="id")
     * })
     */
    private $moeda;

    /**
     * @var \Doctrine\Common\Collections\Collection
     *
     * @ORM\ManyToMany(targetEntity="Justificacao", inversedBy="comparticipacaoR")
     * @ORM\JoinTable(name="comparticipacao_r_justificacao",
     *   joinColumns={
     *     @ORM\JoinColumn(name="Comparticipacao_R", referencedColumnName="id")
     *   },
     *   inverseJoinColumns={
     *     @ORM\JoinColumn(name="Justificacao", referencedColumnName="id")
     *   }
     * )
     */
    private $justificacao;

    /**
     * Constructor
     */
    public function __construct()
    {
        $this->justificacao = new \Doctrine\Common\Collections\ArrayCollection();
    }


    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set valor
     *
     * @param float $valor
     * @return ComparticipacaoResposta
     */
    public function setValor($valor)
    {
        $this->valor = $valor;

        return $this;
    }

    /**
     * Get valor
     *
     * @return float 
     */
    public function getValor()
    {
        return $this->valor;
    }

    /**
     * Set resposta
     *
     * @param string $resposta
     * @return ComparticipacaoResposta
     */
    public function setResposta($resposta)
    {
        $this->resposta = $resposta;

        return $this;
    }

    /**
     * Get resposta
     *
     * @return string 
     */
    public function getResposta()
    {
        return $this->resposta;
    }

    /**
     * Set data
     *
     * @param \DateTime $data
     * @return ComparticipacaoResposta
     */
    public function setData($data)
    {
        $this->data = $data;

        return $this;
    }

    /**
     * Get data
     *
     * @return \DateTime 
     */
    public function getData()
    {
        return $this->data;
    }

    /**
     * Set observacao
     *
     * @param string $observacao
     * @return ComparticipacaoResposta
     */
    public function setObservacao($observacao)
    {
        $this->observacao = $observacao;

        return $this;
    }

    /**
     * Get observacao
     *
     * @return string 
     */
    public function getObservacao()
    {
        return $this->observacao;
    }

    /**
     * Set comparticipacao
     *
     * @param \Usoko\SIGBundle\Entity\Comparticipacao $comparticipacao
     * @return ComparticipacaoResposta
     */
    public function setComparticipacao(\Usoko\SIGBundle\Entity\Comparticipacao $comparticipacao = null)
    {
        $this->comparticipacao = $comparticipacao;

        return $this;
    }

    /**
     * Get comparticipacao
     *
     * @return \Usoko\SIGBundle\Entity\Comparticipacao 
     */
    public function getComparticipacao()
    {
        return $this->comparticipacao;
    }

    /**
     * Set moeda
     *
     * @param \Usoko\SIGBundle\Entity\Moeda $moeda
     * @return ComparticipacaoResposta
     */
    public function setMoeda(\Usoko\SIGBundle\Entity\Moeda $moeda = null)
    {
        $this->moeda = $moeda;

        return $this;
    }

    /**
     * Get moeda
     *
     * @return \Usoko\SIGBundle\Entity\Moeda 
     */
    public function getMoeda()
    {
        return $this->moeda;
    }

    /**
     * Add justificacao
     *
     * @param \Usoko\SIGBundle\Entity\Justificacao $justificacao
     * @return ComparticipacaoResposta
     */
    public function addJustificacao(\Usoko\SIGBundle\Entity\Justificacao $justificacao)
    {
        $this->justificacao[] = $justificacao;

        return $this;
    }

    /**
     * Remove justificacao
     *
     * @param \Usoko\SIGBundle\Entity\Justificacao $justificacao
     */
    public function removeJustificacao(\Usoko\SIGBundle\Entity\Justificacao $justificacao)
    {
        $this->justificacao->removeElement($justificacao);
    }

    /**
     * Get justificacao
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getJustificacao()
    {
        return $this->justificacao;
    }
    
    public function __toString() {
        return $this->getResposta();
    }
}
