<?php

namespace Usoko\SIGBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * Contacto
 *
 * @ORM\Table(name="contacto", indexes={@ORM\Index(name="fk_Contacto_TipoContacto1_idx", columns={"TipoContacto"})})
 * @ORM\Entity
 */
class Contacto
{
    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $id;

    /**
     * @var string
     *
     * @ORM\Column(name="nome", type="string", length=60, nullable=false)
     */
    private $nome;

    /**
     * @var \Tipocontacto
     *
     * @ORM\ManyToOne(targetEntity="Tipocontacto")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="TipoContacto", referencedColumnName="id")
     * })
     */
    private $tipocontacto;

    /**
     * @var \Doctrine\Common\Collections\Collection
     *
     * @ORM\ManyToMany(targetEntity="Pessoa", mappedBy="contacto")
     */
    private $pessoa;

    /**
     * Constructor
     */
    public function __construct()
    {
        $this->pessoa = new \Doctrine\Common\Collections\ArrayCollection();
    }


    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set nome
     *
     * @param string $nome
     * @return Contacto
     */
    public function setNome($nome)
    {
        $this->nome = $nome;

        return $this;
    }

    /**
     * Get nome
     *
     * @return string 
     */
    public function getNome()
    {
        return $this->nome;
    }

    /**
     * Set tipocontacto
     *
     * @param \Usoko\SIGBundle\Entity\Tipocontacto $tipocontacto
     * @return Contacto
     */
    public function setTipocontacto(\Usoko\SIGBundle\Entity\Tipocontacto $tipocontacto = null)
    {
        $this->tipocontacto = $tipocontacto;

        return $this;
    }

    /**
     * Get tipocontacto
     *
     * @return \Usoko\SIGBundle\Entity\Tipocontacto 
     */
    public function getTipocontacto()
    {
        return $this->tipocontacto;
    }

    /**
     * Add pessoa
     *
     * @param \Usoko\SIGBundle\Entity\Pessoa $pessoa
     * @return Contacto
     */
    public function addPessoa(\Usoko\SIGBundle\Entity\Pessoa $pessoa)
    {
        $this->pessoa[] = $pessoa;

        return $this;
    }

    /**
     * Remove pessoa
     *
     * @param \Usoko\SIGBundle\Entity\Pessoa $pessoa
     */
    public function removePessoa(\Usoko\SIGBundle\Entity\Pessoa $pessoa)
    {
        $this->pessoa->removeElement($pessoa);
    }

    /**
     * Get pessoa
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getPessoa()
    {
        return $this->pessoa;
    }
    
    public function __toString() {
        return $this->getPessoa()." - ".$this->getTipocontacto()." - ".
               $this->getNome();
    }
}
