<?php

namespace Usoko\SIGBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * CreditoPlafond
 *
 * @ORM\Table(name="credito_plafond", uniqueConstraints={@ORM\UniqueConstraint(name="ano_UNIQUE", columns={"ano"})})
 * @ORM\Entity
 */
class CreditoPlafond {

    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $id;

    /**
     * @var string
     *
     * @ORM\Column(name="ano", type="string", length=4, nullable=false)
     */
    private $ano;

    /**
     * @var float
     *
     * @ORM\Column(name="valorlimite", type="float", precision=10, scale=0, nullable=false)
     */
    private $valorlimite = '0';

    /**
     * @var float
     *
     * @ORM\Column(name="valorconcedido", type="float", precision=10, scale=0, nullable=false)
     */
    private $valorconcedido = '0';

    /**
     * @var integer
     *
     * @ORM\Column(name="taxajuros", type="integer", nullable=false)
     */
    private $taxajuros = '0';

    /**
     * @var string
     *
     * @ORM\Column(name="descricao", type="text", nullable=true)
     */
    private $descricao;

    /**
     * Get id
     *
     * @return integer 
     */
    public function getId() {
        return $this->id;
    }

    /**
     * Set ano
     *
     * @param string $ano
     * @return CreditoPlafond
     */
    public function setAno($ano) {
        $this->ano = $ano;

        return $this;
    }

    /**
     * Get ano
     *
     * @return string 
     */
    public function getAno() {
        return $this->ano;
    }

    /**
     * Set valorlimite
     *
     * @param float $valorlimite
     * @return CreditoPlafond
     */
    public function setValorlimite($valorlimite) {
        $this->valorlimite = $valorlimite;

        return $this;
    }

    /**
     * Get valorlimite
     *
     * @return float 
     */
    public function getValorlimite() {
        return $this->valorlimite;
    }

    /**
     * Set valorconcedido
     *
     * @param float $valorconcedido
     * @return CreditoPlafond
     */
    public function setValorconcedido($valorconcedido) {
        $this->valorconcedido = $valorconcedido;

        return $this;
    }

    /**
     * Get valorconcedido
     *
     * @return float 
     */
    public function getValorconcedido() {
        return $this->valorconcedido;
    }

    /**
     * Set taxajuros
     *
     * @param integer $taxajuros
     * @return CreditoPlafond
     */
    public function setTaxajuros($taxajuros) {
        $this->taxajuros = $taxajuros;

        return $this;
    }

    /**
     * Get taxajuros
     *
     * @return integer 
     */
    public function getTaxajuros() {
        return $this->taxajuros;
    }

    /**
     * Set descricao
     *
     * @param string $descricao
     * @return CreditoPlafond
     */
    public function setDescricao($descricao) {
        $this->descricao = $descricao;

        return $this;
    }

    /**
     * Get descricao
     *
     * @return string 
     */
    public function getDescricao() {
        return $this->descricao;
    }
    
    public function __toString() {
        return $this->getAno();
    }

}
