<?php

namespace Usoko\SIGBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * CreditoResposta
 *
 * @ORM\Table(name="credito_resposta", uniqueConstraints={@ORM\UniqueConstraint(name="Credito_Pedido", columns={"Credito_Pedido"})}, indexes={@ORM\Index(name="fk_resp_moeda", columns={"moeda"})})
 * @ORM\Entity
 */
class CreditoResposta
{
    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $id;

    /**
     * @var float
     *
     * @ORM\Column(name="valor", type="float", precision=10, scale=0, nullable=true)
     */
    private $valor;

    /**
     * @var float
     *
     * @ORM\Column(name="valorPagar", type="float", precision=10, scale=0, nullable=true)
     */
    private $valorpagar;

    /**
     * @var integer
     *
     * @ORM\Column(name="valor_mensal", type="integer", nullable=true)
     */
    private $valorMensal;

    /**
     * @var integer
     *
     * @ORM\Column(name="tempo_amortizacao", type="integer", nullable=true)
     */
    private $tempoAmortizacao;

    /**
     * @var string
     *
     * @ORM\Column(name="resposta", type="string", length=2, nullable=false)
     */
    private $resposta;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="data", type="datetime", nullable=false)
     */
    private $data;

    /**
     * @var string
     *
     * @ORM\Column(name="observacao", type="text", nullable=true)
     */
    private $observacao;

    /**
     * @var \CreditoPedido
     *
     * @ORM\ManyToOne(targetEntity="CreditoPedido")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="Credito_Pedido", referencedColumnName="id")
     * })
     */
    private $creditoPedido;

    /**
     * @var \Moeda
     *
     * @ORM\ManyToOne(targetEntity="Moeda")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="moeda", referencedColumnName="id")
     * })
     */
    private $moeda;

    /**
     * @var \Doctrine\Common\Collections\Collection
     *
     * @ORM\ManyToMany(targetEntity="Justificacao", inversedBy="creditoResposta")
     * @ORM\JoinTable(name="credito_r_justificacao",
     *   joinColumns={
     *     @ORM\JoinColumn(name="Credito_Resposta", referencedColumnName="id")
     *   },
     *   inverseJoinColumns={
     *     @ORM\JoinColumn(name="Justificacao", referencedColumnName="id")
     *   }
     * )
     */
    private $justificacao;

    /**
     * Constructor
     */
    public function __construct()
    {
        $this->justificacao = new \Doctrine\Common\Collections\ArrayCollection();
    }


    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set valor
     *
     * @param float $valor
     * @return CreditoResposta
     */
    public function setValor($valor)
    {
        $this->valor = $valor;

        return $this;
    }

    /**
     * Get valor
     *
     * @return float 
     */
    public function getValor()
    {
        return $this->valor;
    }

    /**
     * Set valorpagar
     *
     * @param float $valorpagar
     * @return CreditoResposta
     */
    public function setValorpagar($valorpagar)
    {
        $this->valorpagar = $valorpagar;

        return $this;
    }

    /**
     * Get valorpagar
     *
     * @return float 
     */
    public function getValorpagar()
    {
        return $this->valorpagar;
    }

    /**
     * Set valorMensal
     *
     * @param integer $valorMensal
     * @return CreditoResposta
     */
    public function setValorMensal($valorMensal)
    {
        $this->valorMensal = $valorMensal;

        return $this;
    }

    /**
     * Get valorMensal
     *
     * @return integer 
     */
    public function getValorMensal()
    {
        return $this->valorMensal;
    }

    /**
     * Set tempoAmortizacao
     *
     * @param integer $tempoAmortizacao
     * @return CreditoResposta
     */
    public function setTempoAmortizacao($tempoAmortizacao)
    {
        $this->tempoAmortizacao = $tempoAmortizacao;

        return $this;
    }

    /**
     * Get tempoAmortizacao
     *
     * @return integer 
     */
    public function getTempoAmortizacao()
    {
        return $this->tempoAmortizacao;
    }

    /**
     * Set resposta
     *
     * @param string $resposta
     * @return CreditoResposta
     */
    public function setResposta($resposta)
    {
        $this->resposta = $resposta;

        return $this;
    }

    /**
     * Get resposta
     *
     * @return string 
     */
    public function getResposta()
    {
        return $this->resposta;
    }

    /**
     * Set data
     *
     * @param \DateTime $data
     * @return CreditoResposta
     */
    public function setData($data)
    {
        $this->data = $data;

        return $this;
    }

    /**
     * Get data
     *
     * @return \DateTime 
     */
    public function getData()
    {
        return $this->data;
    }

    /**
     * Set observacao
     *
     * @param string $observacao
     * @return CreditoResposta
     */
    public function setObservacao($observacao)
    {
        $this->observacao = $observacao;

        return $this;
    }

    /**
     * Get observacao
     *
     * @return string 
     */
    public function getObservacao()
    {
        return $this->observacao;
    }

    /**
     * Set creditoPedido
     *
     * @param \Usoko\SIGBundle\Entity\CreditoPedido $creditoPedido
     * @return CreditoResposta
     */
    public function setCreditoPedido(\Usoko\SIGBundle\Entity\CreditoPedido $creditoPedido = null)
    {
        $this->creditoPedido = $creditoPedido;

        return $this;
    }

    /**
     * Get creditoPedido
     *
     * @return \Usoko\SIGBundle\Entity\CreditoPedido 
     */
    public function getCreditoPedido()
    {
        return $this->creditoPedido;
    }

    /**
     * Set moeda
     *
     * @param \Usoko\SIGBundle\Entity\Moeda $moeda
     * @return CreditoResposta
     */
    public function setMoeda(\Usoko\SIGBundle\Entity\Moeda $moeda = null)
    {
        $this->moeda = $moeda;

        return $this;
    }

    /**
     * Get moeda
     *
     * @return \Usoko\SIGBundle\Entity\Moeda 
     */
    public function getMoeda()
    {
        return $this->moeda;
    }

    /**
     * Add justificacao
     *
     * @param \Usoko\SIGBundle\Entity\Justificacao $justificacao
     * @return CreditoResposta
     */
    public function addJustificacao(\Usoko\SIGBundle\Entity\Justificacao $justificacao)
    {
        $this->justificacao[] = $justificacao;

        return $this;
    }

    /**
     * Remove justificacao
     *
     * @param \Usoko\SIGBundle\Entity\Justificacao $justificacao
     */
    public function removeJustificacao(\Usoko\SIGBundle\Entity\Justificacao $justificacao)
    {
        $this->justificacao->removeElement($justificacao);
    }

    /**
     * Get justificacao
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getJustificacao()
    {
        return $this->justificacao;
    }
    
    public function __toString() {
        return $this->getResposta();
    }
}
