<?php

namespace Usoko\SIGBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * Dependente
 *
 * @ORM\Table(name="dependente", indexes={@ORM\Index(name="fk_Dependentes_Pessoa1_idx", columns={"Pessoa"}), @ORM\Index(name="fk_Dependentes_Profissao1_idx", columns={"Profissao"})})
 * @ORM\Entity
 */
class Dependente
{
    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $id;

    /**
     * @var \Pessoa
     *
     * @ORM\ManyToOne(targetEntity="Pessoa", cascade={"persist"})
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="Pessoa", referencedColumnName="id")
     * })
     */
    private $pessoa;

    /**
     * @var \Profissao
     *
     * @ORM\ManyToOne(targetEntity="Profissao")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="Profissao", referencedColumnName="id")
     * })
     */
    private $profissao;

    public function __toString() {
        return $this->getPessoa()->getNome();
    }
    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set pessoa
     *
     * @param \Usoko\SIGBundle\Entity\Pessoa $pessoa
     * @return Dependente
     */
    public function setPessoa(\Usoko\SIGBundle\Entity\Pessoa $pessoa = null)
    {
        $this->pessoa = $pessoa;

        return $this;
    }

    /**
     * Get pessoa
     *
     * @return \Usoko\SIGBundle\Entity\Pessoa 
     */
    public function getPessoa()
    {
        return $this->pessoa;
    }

    /**
     * Set profissao
     *
     * @param \Usoko\SIGBundle\Entity\Profissao $profissao
     * @return Dependente
     */
    public function setProfissao(\Usoko\SIGBundle\Entity\Profissao $profissao = null)
    {
        $this->profissao = $profissao;

        return $this;
    }

    /**
     * Get profissao
     *
     * @return \Usoko\SIGBundle\Entity\Profissao 
     */
    public function getProfissao()
    {
        return $this->profissao;
    }
}
