<?php

namespace Usoko\SIGBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

//Atencao a este repositorio
/**
 * @ORM\Entity(repositoryClass="SIGBundle\Repository\DocumentoidentificacaoRepository")
 */

/**
 * Documentoidentificacao
 *
 * @ORM\Table(name="documentoidentificacao", uniqueConstraints={@ORM\UniqueConstraint(name="numero_UNIQUE", columns={"numero"})}, indexes={@ORM\Index(name="fk_DocumentoIdentificacao_TipoDocumento1_idx", columns={"TipoDocumento_id"})})
 * @ORM\Entity
 */
class Documentoidentificacao
{
    public function __toString() {
        return $this->numero.'';
    }
    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $id;

    /**
     * @var string
     *
     * @ORM\Column(name="numero", type="string", length=45, nullable=false)
     */
    private $numero;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="data_emissao", type="date", nullable=true)
     */
    private $dataEmissao;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="data_expiracao", type="date", nullable=true)
     */
    private $dataExpiracao;

    /**
     * @var string
     *
     * @ORM\Column(name="local_emissao", type="string", length=100, nullable=true)
     */
    private $localEmissao;

    /**
     * @var string
     *
     * @ORM\Column(name="anexo", type="string", length=200, nullable=true)
     */
    private $anexo;

    /**
     * @var \Tipodocumento
     *
     * @ORM\ManyToOne(targetEntity="Tipodocumento")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="TipoDocumento_id", referencedColumnName="id")
     * })
     */
    private $tipodocumento;

    /**
     * @var \Doctrine\Common\Collections\Collection
     *
     * @ORM\ManyToMany(targetEntity="Pessoa", mappedBy="documentoidentificacao")
     */
    private $pessoa;

    /**
     * Constructor
     */
    public function __construct()
    {
        $this->pessoa = new \Doctrine\Common\Collections\ArrayCollection();
    }


    /**
     * Get id
     *
     * @return integer
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set numero
     *
     * @param string $numero
     * @return Documentoidentificacao
     */
    public function setNumero($numero)
    {
        $this->numero = $numero;

        return $this;
    }

    /**
     * Get numero
     *
     * @return string
     */
    public function getNumero()
    {
        return $this->numero;
    }

    /**
     * Set dataEmissao
     *
     * @param \DateTime $dataEmissao
     * @return Documentoidentificacao
     */
    public function setDataEmissao($dataEmissao)
    {
        $this->dataEmissao = $dataEmissao;

        return $this;
    }

    /**
     * Get dataEmissao
     *
     * @return \DateTime
     */
    public function getDataEmissao()
    {
        return $this->dataEmissao;
    }

    /**
     * Set dataExpiracao
     *
     * @param \DateTime $dataExpiracao
     * @return Documentoidentificacao
     */
    public function setDataExpiracao($dataExpiracao)
    {
        $this->dataExpiracao = $dataExpiracao;

        return $this;
    }

    /**
     * Get dataExpiracao
     *
     * @return \DateTime
     */
    public function getDataExpiracao()
    {
        return $this->dataExpiracao;
    }

    /**
     * Set localEmissao
     *
     * @param string $localEmissao
     * @return Documentoidentificacao
     */
    public function setLocalEmissao($localEmissao)
    {
        $this->localEmissao = $localEmissao;

        return $this;
    }

    /**
     * Get localEmissao
     *
     * @return string
     */
    public function getLocalEmissao()
    {
        return $this->localEmissao;
    }

    /**
     * Set anexo
     *
     * @param string $anexo
     * @return Documentoidentificacao
     */
    public function setAnexo($anexo)
    {
        $this->anexo = $anexo;

        return $this;
    }

    /**
     * Get anexo
     *
     * @return string
     */
    public function getAnexo()
    {
        return $this->anexo;
    }

    /**
     * Set tipodocumento
     *
     * @param \Usoko\SIGBundle\Entity\Tipodocumento $tipodocumento
     * @return Documentoidentificacao
     */
    public function setTipodocumento(\Usoko\SIGBundle\Entity\Tipodocumento $tipodocumento = null)
    {
        $this->tipodocumento = $tipodocumento;

        return $this;
    }

    /**
     * Get tipodocumento
     *
     * @return \Usoko\SIGBundle\Entity\Tipodocumento
     */
    public function getTipodocumento()
    {
        return $this->tipodocumento;
    }

    /**
     * Add pessoa
     *
     * @param \Usoko\SIGBundle\Entity\Pessoa $pessoa
     * @return Documentoidentificacao
     */
    public function addPessoa(\Usoko\SIGBundle\Entity\Pessoa $pessoa)
    {
        $this->pessoa[] = $pessoa;

        return $this;
    }

    /**
     * Remove pessoa
     *
     * @param \Usoko\SIGBundle\Entity\Pessoa $pessoa
     */
    public function removePessoa(\Usoko\SIGBundle\Entity\Pessoa $pessoa)
    {
        $this->pessoa->removeElement($pessoa);
    }

    /**
     * Get pessoa
     *
     * @return \Doctrine\Common\Collections\Collection
     */
    public function getPessoa()
    {
        return $this->pessoa;
    }
}
