<?php

namespace Usoko\SIGBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * Endereco
 *
 * @ORM\Table(name="endereco", indexes={@ORM\Index(name="fk_Endereco_Provincia_idx", columns={"Provincia"}), @ORM\Index(name="fk_Endereco_Municipio1_idx", columns={"Municipio"})})
 * @ORM\Entity
 */
class Endereco
{
    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $id;

    /**
     * @var string
     *
     * @ORM\Column(name="bairro", type="string", length=45, nullable=false)
     */
    private $bairro;

    /**
     * @var string
     *
     * @ORM\Column(name="rua", type="string", length=45, nullable=true)
     */
    private $rua;

    /**
     * @var string
     *
     * @ORM\Column(name="numero", type="string", length=45, nullable=true)
     */
    private $numero;

    /**
     * @var string
     *
     * @ORM\Column(name="descricao", type="string", length=100, nullable=true)
     */
    private $descricao;

    /**
     * @var \Provincia
     *
     * @ORM\ManyToOne(targetEntity="Provincia")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="Provincia", referencedColumnName="id")
     * })
     */
    private $provincia;

    /**
     * @var \Municipio
     *
     * @ORM\ManyToOne(targetEntity="Municipio")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="Municipio", referencedColumnName="id")
     * })
     */
    private $municipio;

    /**
     * @var \Doctrine\Common\Collections\Collection
     *
     * @ORM\ManyToMany(targetEntity="Pessoa", mappedBy="endereco")
     */
    private $pessoa;

    /**
     * Constructor
     */
    public function __construct()
    {
        $this->pessoa = new \Doctrine\Common\Collections\ArrayCollection();
    }


    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set bairro
     *
     * @param string $bairro
     * @return Endereco
     */
    public function setBairro($bairro)
    {
        $this->bairro = $bairro;

        return $this;
    }

    /**
     * Get bairro
     *
     * @return string 
     */
    public function getBairro()
    {
        return $this->bairro;
    }

    /**
     * Set rua
     *
     * @param string $rua
     * @return Endereco
     */
    public function setRua($rua)
    {
        $this->rua = $rua;

        return $this;
    }

    /**
     * Get rua
     *
     * @return string 
     */
    public function getRua()
    {
        return $this->rua;
    }

    /**
     * Set numero
     *
     * @param string $numero
     * @return Endereco
     */
    public function setNumero($numero)
    {
        $this->numero = $numero;

        return $this;
    }

    /**
     * Get numero
     *
     * @return string 
     */
    public function getNumero()
    {
        return $this->numero;
    }

    /**
     * Set descricao
     *
     * @param string $descricao
     * @return Endereco
     */
    public function setDescricao($descricao)
    {
        $this->descricao = $descricao;

        return $this;
    }

    /**
     * Get descricao
     *
     * @return string 
     */
    public function getDescricao()
    {
        return $this->descricao;
    }

    /**
     * Set provincia
     *
     * @param \Usoko\SIGBundle\Entity\Provincia $provincia
     * @return Endereco
     */
    public function setProvincia(\Usoko\SIGBundle\Entity\Provincia $provincia = null)
    {
        $this->provincia = $provincia;

        return $this;
    }

    /**
     * Get provincia
     *
     * @return \Usoko\SIGBundle\Entity\Provincia 
     */
    public function getProvincia()
    {
        return $this->provincia;
    }

    /**
     * Set municipio
     *
     * @param \Usoko\SIGBundle\Entity\Municipio $municipio
     * @return Endereco
     */
    public function setMunicipio(\Usoko\SIGBundle\Entity\Municipio $municipio = null)
    {
        $this->municipio = $municipio;

        return $this;
    }

    /**
     * Get municipio
     *
     * @return \Usoko\SIGBundle\Entity\Municipio 
     */
    public function getMunicipio()
    {
        return $this->municipio;
    }

    /**
     * Add pessoa
     *
     * @param \Usoko\SIGBundle\Entity\Pessoa $pessoa
     * @return Endereco
     */
    public function addPessoa(\Usoko\SIGBundle\Entity\Pessoa $pessoa)
    {
        $this->pessoa[] = $pessoa;

        return $this;
    }

    /**
     * Remove pessoa
     *
     * @param \Usoko\SIGBundle\Entity\Pessoa $pessoa
     */
    public function removePessoa(\Usoko\SIGBundle\Entity\Pessoa $pessoa)
    {
        $this->pessoa->removeElement($pessoa);
    }

    /**
     * Get pessoa
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getPessoa()
    {
        return $this->pessoa;
    }
    
    public function __toString() {
        return $this->getProvincia()." - ".$this->getMunicipio()." - ".
            $this->getBairro()." - ".$this->getRua()." - ".$this->getNumero();
    }
}
