<?php

namespace Usoko\SIGBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
//Atencao a este repositorio
/**
 * @ORM\Entity(repositoryClass="SIGBundle\Repository\PessoaDocumentoRepository")
 */

/**
 * PessoaDocumento
 *
 * @ORM\Table(name="pessoa_documento", indexes={@ORM\Index(name="fk_Pessoa_has_DocumentoIdentificacao_DocumentoIdentificacao_idx", columns={"DocumentoIdentificacao"})})
 * @ORM\Entity
 */
class PessoaDocumento
{
    /**
     * @var \Pessoa
     *
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     * @ORM\OneToOne(targetEntity="Pessoa")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="Pessoa", referencedColumnName="id")
     * })
     */
    private $pessoa;

    /**
     * @var \Documentoidentificacao
     *
     * @ORM\ManyToOne(targetEntity="Documentoidentificacao")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="DocumentoIdentificacao", referencedColumnName="id")
     * })
     */
    private $documentoidentificacao;



    /**
     * Set pessoa
     *
     * @param \Usoko\SIGBundle\Entity\Pessoa $pessoa
     * @return PessoaDocumento
     */
    public function setPessoa(\Usoko\SIGBundle\Entity\Pessoa $pessoa)
    {
        $this->pessoa = $pessoa;

        return $this;
    }

    /**
     * Get pessoa
     *
     * @return \Usoko\SIGBundle\Entity\Pessoa
     */
    public function getPessoa()
    {
        return $this->pessoa;
    }

    /**
     * Set documentoidentificacao
     *
     * @param \Usoko\SIGBundle\Entity\Documentoidentificacao $documentoidentificacao
     * @return PessoaDocumento
     */
    public function setDocumentoidentificacao(\Usoko\SIGBundle\Entity\Documentoidentificacao $documentoidentificacao = null)
    {
        $this->documentoidentificacao = $documentoidentificacao;

        return $this;
    }

    /**
     * Get documentoidentificacao
     *
     * @return \Usoko\SIGBundle\Entity\Documentoidentificacao
     */
    public function getDocumentoidentificacao()
    {
        return $this->documentoidentificacao;
    }
}
