<?php

namespace Usoko\SIGBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * PlanoPensao
 *
 * @ORM\Table(name="plano_pensao", indexes={@ORM\Index(name="fk_pensao_associado", columns={"associado"}), @ORM\Index(name="fk_pensao_moeda", columns={"moeda"})})
 * @ORM\Entity
 */
class PlanoPensao
{
    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $id;

    /**
     * @var float
     *
     * @ORM\Column(name="valor", type="float", precision=10, scale=0, nullable=false)
     */
    private $valor;

    /**
     * @var string
     *
     * @ORM\Column(name="anexo", type="string", length=150, nullable=true)
     */
    private $anexo;

    /**
     * @var string
     *
     * @ORM\Column(name="descricao", type="text", nullable=true)
     */
    private $descricao;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="data", type="date", nullable=false)
     */
    private $data;

    /**
     * @var string
     *
     * @ORM\Column(name="estado", type="string", length=1, nullable=false)
     */
    private $estado;

    /**
     * @var \Moeda
     *
     * @ORM\ManyToOne(targetEntity="Moeda")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="moeda", referencedColumnName="id")
     * })
     */
    private $moeda;

    /**
     * @var \Associado
     *
     * @ORM\ManyToOne(targetEntity="Associado")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="associado", referencedColumnName="id")
     * })
     */
    private $associado;



    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set valor
     *
     * @param float $valor
     * @return PlanoPensao
     */
    public function setValor($valor)
    {
        $this->valor = $valor;

        return $this;
    }

    /**
     * Get valor
     *
     * @return float 
     */
    public function getValor()
    {
        return $this->valor;
    }

    /**
     * Set anexo
     *
     * @param string $anexo
     * @return PlanoPensao
     */
    public function setAnexo($anexo)
    {
        $this->anexo = $anexo;

        return $this;
    }

    /**
     * Get anexo
     *
     * @return string 
     */
    public function getAnexo()
    {
        return $this->anexo;
    }

    /**
     * Set descricao
     *
     * @param string $descricao
     * @return PlanoPensao
     */
    public function setDescricao($descricao)
    {
        $this->descricao = $descricao;

        return $this;
    }

    /**
     * Get descricao
     *
     * @return string 
     */
    public function getDescricao()
    {
        return $this->descricao;
    }

    /**
     * Set data
     *
     * @param \DateTime $data
     * @return PlanoPensao
     */
    public function setData($data)
    {
        $this->data = $data;

        return $this;
    }

    /**
     * Get data
     *
     * @return \DateTime 
     */
    public function getData()
    {
        return $this->data;
    }

    /**
     * Set estado
     *
     * @param string $estado
     * @return PlanoPensao
     */
    public function setEstado($estado)
    {
        $this->estado = $estado;

        return $this;
    }

    /**
     * Get estado
     *
     * @return string 
     */
    public function getEstado()
    {
        return $this->estado;
    }

    /**
     * Set moeda
     *
     * @param \Usoko\SIGBundle\Entity\Moeda $moeda
     * @return PlanoPensao
     */
    public function setMoeda(\Usoko\SIGBundle\Entity\Moeda $moeda = null)
    {
        $this->moeda = $moeda;

        return $this;
    }

    /**
     * Get moeda
     *
     * @return \Usoko\SIGBundle\Entity\Moeda 
     */
    public function getMoeda()
    {
        return $this->moeda;
    }

    /**
     * Set associado
     *
     * @param \Usoko\SIGBundle\Entity\Associado $associado
     * @return PlanoPensao
     */
    public function setAssociado(\Usoko\SIGBundle\Entity\Associado $associado = null)
    {
        $this->associado = $associado;

        return $this;
    }

    /**
     * Get associado
     *
     * @return \Usoko\SIGBundle\Entity\Associado 
     */
    public function getAssociado()
    {
        return $this->associado;
    }
    
    public function __toString() {
        return $this->getAssociado()->getPessoa()->getNome();
    }
}
