<?php

namespace Usoko\SIGBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * PpAumento
 *
 * @ORM\Table(name="pp_aumento", indexes={@ORM\Index(name="fk_PP_Aumento_Plano_Pensao1_idx", columns={"Plano_Pensao"})})
 * @ORM\Entity
 */
class PpAumento
{
    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $id;

    /**
     * @var float
     *
     * @ORM\Column(name="valor_antes", type="float", precision=10, scale=0, nullable=false)
     */
    private $valorAntes;

    /**
     * @var float
     *
     * @ORM\Column(name="valor_pos", type="float", precision=10, scale=0, nullable=false)
     */
    private $valorPos;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="data", type="datetime", nullable=true)
     */
    private $data;

    /**
     * @var string
     *
     * @ORM\Column(name="anexo", type="string", length=150, nullable=true)
     */
    private $anexo;

    /**
     * @var string
     *
     * @ORM\Column(name="descricao", type="text", nullable=true)
     */
    private $descricao;

    /**
     * @var \PlanoPensao
     *
     * @ORM\ManyToOne(targetEntity="PlanoPensao")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="Plano_Pensao", referencedColumnName="id")
     * })
     */
    private $planoPensao;



    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set valorAntes
     *
     * @param float $valorAntes
     * @return PpAumento
     */
    public function setValorAntes($valorAntes)
    {
        $this->valorAntes = $valorAntes;

        return $this;
    }

    /**
     * Get valorAntes
     *
     * @return float 
     */
    public function getValorAntes()
    {
        return $this->valorAntes;
    }

    /**
     * Set valorPos
     *
     * @param float $valorPos
     * @return PpAumento
     */
    public function setValorPos($valorPos)
    {
        $this->valorPos = $valorPos;

        return $this;
    }

    /**
     * Get valorPos
     *
     * @return float 
     */
    public function getValorPos()
    {
        return $this->valorPos;
    }

    /**
     * Set data
     *
     * @param \DateTime $data
     * @return PpAumento
     */
    public function setData($data)
    {
        $this->data = $data;

        return $this;
    }

    /**
     * Get data
     *
     * @return \DateTime 
     */
    public function getData()
    {
        return $this->data;
    }

    /**
     * Set anexo
     *
     * @param string $anexo
     * @return PpAumento
     */
    public function setAnexo($anexo)
    {
        $this->anexo = $anexo;

        return $this;
    }

    /**
     * Get anexo
     *
     * @return string 
     */
    public function getAnexo()
    {
        return $this->anexo;
    }

    /**
     * Set descricao
     *
     * @param string $descricao
     * @return PpAumento
     */
    public function setDescricao($descricao)
    {
        $this->descricao = $descricao;

        return $this;
    }

    /**
     * Get descricao
     *
     * @return string 
     */
    public function getDescricao()
    {
        return $this->descricao;
    }

    /**
     * Set planoPensao
     *
     * @param \Usoko\SIGBundle\Entity\PlanoPensao $planoPensao
     * @return PpAumento
     */
    public function setPlanoPensao(\Usoko\SIGBundle\Entity\PlanoPensao $planoPensao = null)
    {
        $this->planoPensao = $planoPensao;

        return $this;
    }

    /**
     * Get planoPensao
     *
     * @return \Usoko\SIGBundle\Entity\PlanoPensao 
     */
    public function getPlanoPensao()
    {
        return $this->planoPensao;
    }
    
    public function __toString() {
        return $this->getPlanoPensao()." - Valor Anterior: ".$this->getValorAntes()." - Actual: ".$this->getValorPos();
    }
}
