<?php

namespace Usoko\SIGBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * PpDesvinculacao
 *
 * @ORM\Table(name="pp_desvinculacao", indexes={@ORM\Index(name="fk_PP_Desvinculacao_Plano_Pensao1_idx", columns={"Plano_Pensao"})})
 * @ORM\Entity
 */
class PpDesvinculacao
{
    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $id;

    /**
     * @var float
     *
     * @ORM\Column(name="valor", type="float", precision=10, scale=0, nullable=false)
     */
    private $valor = '0';

    /**
     * @var integer
     *
     * @ORM\Column(name="percentagem", type="integer", nullable=false)
     */
    private $percentagem;

    /**
     * @var string
     *
     * @ORM\Column(name="anexo", type="string", length=150, nullable=true)
     */
    private $anexo;

    /**
     * @var string
     *
     * @ORM\Column(name="descricao", type="text", nullable=true)
     */
    private $descricao;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="data", type="datetime", nullable=false)
     */
    private $data;

    /**
     * @var float
     *
     * @ORM\Column(name="valorTotalPP", type="float", precision=10, scale=0, nullable=false)
     */
    private $valortotalpp;

    /**
     * @var string
     *
     * @ORM\Column(name="tempoPP", type="string", length=70, nullable=false)
     */
    private $tempopp;

    /**
     * @var string
     *
     * @ORM\Column(name="pago", type="string", length=2, nullable=false)
     */
    private $pago = 'N';

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="dataPag", type="date", nullable=true)
     */
    private $datapag;

    /**
     * @var \PlanoPensao
     *
     * @ORM\ManyToOne(targetEntity="PlanoPensao")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="Plano_Pensao", referencedColumnName="id")
     * })
     */
    private $planoPensao;



    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set valor
     *
     * @param float $valor
     * @return PpDesvinculacao
     */
    public function setValor($valor)
    {
        $this->valor = $valor;

        return $this;
    }

    /**
     * Get valor
     *
     * @return float 
     */
    public function getValor()
    {
        return $this->valor;
    }

    /**
     * Set percentagem
     *
     * @param integer $percentagem
     * @return PpDesvinculacao
     */
    public function setPercentagem($percentagem)
    {
        $this->percentagem = $percentagem;

        return $this;
    }

    /**
     * Get percentagem
     *
     * @return integer 
     */
    public function getPercentagem()
    {
        return $this->percentagem;
    }

    /**
     * Set anexo
     *
     * @param string $anexo
     * @return PpDesvinculacao
     */
    public function setAnexo($anexo)
    {
        $this->anexo = $anexo;

        return $this;
    }

    /**
     * Get anexo
     *
     * @return string 
     */
    public function getAnexo()
    {
        return $this->anexo;
    }

    /**
     * Set descricao
     *
     * @param string $descricao
     * @return PpDesvinculacao
     */
    public function setDescricao($descricao)
    {
        $this->descricao = $descricao;

        return $this;
    }

    /**
     * Get descricao
     *
     * @return string 
     */
    public function getDescricao()
    {
        return $this->descricao;
    }

    /**
     * Set data
     *
     * @param \DateTime $data
     * @return PpDesvinculacao
     */
    public function setData($data)
    {
        $this->data = $data;

        return $this;
    }

    /**
     * Get data
     *
     * @return \DateTime 
     */
    public function getData()
    {
        return $this->data;
    }

    /**
     * Set valortotalpp
     *
     * @param float $valortotalpp
     * @return PpDesvinculacao
     */
    public function setValortotalpp($valortotalpp)
    {
        $this->valortotalpp = $valortotalpp;

        return $this;
    }

    /**
     * Get valortotalpp
     *
     * @return float 
     */
    public function getValortotalpp()
    {
        return $this->valortotalpp;
    }

    /**
     * Set tempopp
     *
     * @param string $tempopp
     * @return PpDesvinculacao
     */
    public function setTempopp($tempopp)
    {
        $this->tempopp = $tempopp;

        return $this;
    }

    /**
     * Get tempopp
     *
     * @return string 
     */
    public function getTempopp()
    {
        return $this->tempopp;
    }

    /**
     * Set pago
     *
     * @param string $pago
     * @return PpDesvinculacao
     */
    public function setPago($pago)
    {
        $this->pago = $pago;

        return $this;
    }

    /**
     * Get pago
     *
     * @return string 
     */
    public function getPago()
    {
        return $this->pago;
    }

    /**
     * Set datapag
     *
     * @param \DateTime $datapag
     * @return PpDesvinculacao
     */
    public function setDatapag($datapag)
    {
        $this->datapag = $datapag;

        return $this;
    }

    /**
     * Get datapag
     *
     * @return \DateTime 
     */
    public function getDatapag()
    {
        return $this->datapag;
    }

    /**
     * Set planoPensao
     *
     * @param \Usoko\SIGBundle\Entity\PlanoPensao $planoPensao
     * @return PpDesvinculacao
     */
    public function setPlanoPensao(\Usoko\SIGBundle\Entity\PlanoPensao $planoPensao = null)
    {
        $this->planoPensao = $planoPensao;

        return $this;
    }

    /**
     * Get planoPensao
     *
     * @return \Usoko\SIGBundle\Entity\PlanoPensao 
     */
    public function getPlanoPensao()
    {
        return $this->planoPensao;
    }
    
    public function __toString() {
        return $this->getPlanoPensao();
    }
}
