<?php

namespace Usoko\SIGBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * Quota
 *
 * @ORM\Table(name="quota", indexes={@ORM\Index(name="fk_Quota_Moeda1_idx", columns={"Moeda"})})
 * @ORM\Entity
 */
class Quota
{
    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $id;

    /**
     * @var float
     *
     * @ORM\Column(name="percentagem", type="float", precision=10, scale=0, nullable=false)
     */
    private $percentagem = '002';

    /**
     * @var string
     *
     * @ORM\Column(name="frequencia", type="string", length=2, nullable=false)
     */
    private $frequencia = 'M';

    /**
     * @var string
     *
     * @ORM\Column(name="tipo", type="string", length=1, nullable=false)
     */
    private $tipo = 'B';

    /**
     * @var string
     *
     * @ORM\Column(name="descricao", type="string", length=50, nullable=true)
     */
    private $descricao;

    /**
     * @var \Moeda
     *
     * @ORM\ManyToOne(targetEntity="Moeda")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="Moeda", referencedColumnName="id")
     * })
     */
    private $moeda;


    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set percentagem
     *
     * @param float $percentagem
     * @return Quota
     */
    public function setPercentagem($percentagem)
    {
        $this->percentagem = $percentagem;

        return $this;
    }

    /**
     * Get percentagem
     *
     * @return float 
     */
    public function getPercentagem()
    {
        return $this->percentagem;
    }

    /**
     * Set frequencia
     *
     * @param string $frequencia
     * @return Quota
     */
    public function setFrequencia($frequencia)
    {
        $this->frequencia = $frequencia;

        return $this;
    }

    /**
     * Get frequencia
     *
     * @return string 
     */
    public function getFrequencia()
    {
        return $this->frequencia;
    }

    /**
     * Set tipo
     *
     * @param string $tipo
     * @return Quota
     */
    public function setTipo($tipo)
    {
        $this->tipo = $tipo;

        return $this;
    }

    /**
     * Get tipo
     *
     * @return string 
     */
    public function getTipo()
    {
        return $this->tipo;
    }

    /**
     * Set descricao
     *
     * @param string $descricao
     * @return Quota
     */
    public function setDescricao($descricao)
    {
        $this->descricao = $descricao;

        return $this;
    }

    /**
     * Get descricao
     *
     * @return string 
     */
    public function getDescricao()
    {
        return $this->descricao;
    }

    /**
     * Set moeda
     *
     * @param \Usoko\SIGBundle\Entity\Moeda $moeda
     * @return Quota
     */
    public function setMoeda(\Usoko\SIGBundle\Entity\Moeda $moeda = null)
    {
        $this->moeda = $moeda;

        return $this;
    }

    /**
     * Get moeda
     *
     * @return \Usoko\SIGBundle\Entity\Moeda 
     */
    public function getMoeda()
    {
        return $this->moeda;
    }
    
    public function __toString() {
        return $this->descricao." Frequência: ".$this->getFrequencia();
    }
}
