<?php

namespace Usoko\SIGBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * Simulacao
 *
 * @ORM\Table()
 * @ORM\Entity
 */
class Simulacao
{
    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var integer
     *
     * @ORM\Column(name="totalAnosServico", type="integer")
     */
    private $totalAnosServico;

    /**
     * @var integer
     *
     * @ORM\Column(name="percentagemContribuicao", type="integer")
     */
    private $percentagemContribuicao;

    /**
     * @var \Doctrine\Common\Collections\Collection
     *
     * @ORM\ManyToMany(targetEntity="Taxa", inversedBy="Simulacao")
     * @ORM\JoinTable(name="simulacao_taxa",
     *   joinColumns={
     *     @ORM\JoinColumn(name="Simulacao", referencedColumnName="id")
     *   },
     *   inverseJoinColumns={
     *     @ORM\JoinColumn(name="Taxa", referencedColumnName="id")
     *   }
     * )
     */
    private $taxa;
    
    /**
     * Constructor
     */
    public function __construct() {
        $this->taxa = new \Doctrine\Common\Collections\ArrayCollection();
    }

    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set totalAnosServico
     *
     * @param integer $totalAnosServico
     * @return Simulacao
     */
    public function setTotalAnosServico($totalAnosServico)
    {
        $this->totalAnosServico = $totalAnosServico;

        return $this;
    }

    /**
     * Get totalAnosServico
     *
     * @return integer 
     */
    public function getTotalAnosServico()
    {
        return $this->totalAnosServico;
    }

    /**
     * Set percentagemContribuicao
     *
     * @param integer $percentagemContribuicao
     * @return Simulacao
     */
    public function setPercentagemContribuicao($percentagemContribuicao)
    {
        $this->percentagemContribuicao = $percentagemContribuicao;

        return $this;
    }

    /**
     * Get percentagemContribuicao
     *
     * @return integer 
     */
    public function getPercentagemContribuicao()
    {
        return $this->percentagemContribuicao;
    }

    /**
     * Get taxa
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getTaxa()
    {
        return $this->taxa;
    }

    /**
     * Set taxa
     *
     * @param \Usoko\SIGBundle\Entity\Taxa $taxa
     * @return Simulacao
     */
    public function setTaxa(\Usoko\SIGBundle\Entity\Taxa $taxa = null)
    {
        $this->taxa = $taxa;

        return $this;
    }

    /**
     * Add taxa
     *
     * @param \Usoko\SIGBundle\Entity\Taxa $taxa
     * @return Simulacao
     */
    public function addTaxa(\Usoko\SIGBundle\Entity\Taxa $taxa)
    {
        $this->taxa[] = $taxa;

        return $this;
    }

    /**
     * Remove taxa
     *
     * @param \Usoko\SIGBundle\Entity\Taxa $taxa
     */
    public function removeTaxa(\Usoko\SIGBundle\Entity\Taxa $taxa)
    {
        $this->taxa->removeElement($taxa);
    }
}
