<?php

namespace Usoko\SIGBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * Subsidio
 *
 * @ORM\Table(name="subsidio", indexes={@ORM\Index(name="fk_Apoio_Categoria1_idx", columns={"Categoria"}), @ORM\Index(name="fk_Subsidio_Moeda1_idx", columns={"Moeda"})})
 * @ORM\Entity
 */
class Subsidio
{
    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $id;

    /**
     * @var string
     *
     * @ORM\Column(name="tipo", type="string", length=100, nullable=false)
     */
    private $tipo;

    /**
     * @var float
     *
     * @ORM\Column(name="valor_maximo_titular", type="float", precision=10, scale=0, nullable=false)
     */
    private $valorMaximoTitular;

    /**
     * @var float
     *
     * @ORM\Column(name="valor_maximo_dependente", type="float", precision=10, scale=0, nullable=false)
     */
    private $valorMaximoDependente;

    /**
     * @var \Categoria
     *
     * @ORM\ManyToOne(targetEntity="Categoria")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="Categoria", referencedColumnName="id")
     * })
     */
    private $categoria;

    /**
     * @var \Moeda
     *
     * @ORM\ManyToOne(targetEntity="Moeda")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="Moeda", referencedColumnName="id")
     * })
     */
    private $moeda;



    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set tipo
     *
     * @param string $tipo
     * @return Subsidio
     */
    public function setTipo($tipo)
    {
        $this->tipo = $tipo;

        return $this;
    }

    /**
     * Get tipo
     *
     * @return string 
     */
    public function getTipo()
    {
        return $this->tipo;
    }

    /**
     * Set valorMaximoTitular
     *
     * @param float $valorMaximoTitular
     * @return Subsidio
     */
    public function setValorMaximoTitular($valorMaximoTitular)
    {
        $this->valorMaximoTitular = $valorMaximoTitular;

        return $this;
    }

    /**
     * Get valorMaximoTitular
     *
     * @return float 
     */
    public function getValorMaximoTitular()
    {
        return $this->valorMaximoTitular;
    }

    /**
     * Set valorMaximoDependente
     *
     * @param float $valorMaximoDependente
     * @return Subsidio
     */
    public function setValorMaximoDependente($valorMaximoDependente)
    {
        $this->valorMaximoDependente = $valorMaximoDependente;

        return $this;
    }

    /**
     * Get valorMaximoDependente
     *
     * @return float 
     */
    public function getValorMaximoDependente()
    {
        return $this->valorMaximoDependente;
    }

    /**
     * Set categoria
     *
     * @param \Usoko\SIGBundle\Entity\Categoria $categoria
     * @return Subsidio
     */
    public function setCategoria(\Usoko\SIGBundle\Entity\Categoria $categoria = null)
    {
        $this->categoria = $categoria;

        return $this;
    }

    /**
     * Get categoria
     *
     * @return \Usoko\SIGBundle\Entity\Categoria 
     */
    public function getCategoria()
    {
        return $this->categoria;
    }

    /**
     * Set moeda
     *
     * @param \Usoko\SIGBundle\Entity\Moeda $moeda
     * @return Subsidio
     */
    public function setMoeda(\Usoko\SIGBundle\Entity\Moeda $moeda = null)
    {
        $this->moeda = $moeda;

        return $this;
    }

    /**
     * Get moeda
     *
     * @return \Usoko\SIGBundle\Entity\Moeda 
     */
    public function getMoeda()
    {
        return $this->moeda;
    }
    
    public function __toString() {
        return $this->tipo;
    }
}
