<?php

namespace Usoko\SIGBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * TipoCredito
 *
 * @ORM\Table(name="tipo_credito", uniqueConstraints={@ORM\UniqueConstraint(name="id_UNIQUE", columns={"id"}), @ORM\UniqueConstraint(name="nome_UNIQUE", columns={"nome"})})
 * @ORM\Entity
 */
class TipoCredito
{
    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $id;

    /**
     * @var string
     *
     * @ORM\Column(name="nome", type="string", length=45, nullable=false)
     */
    private $nome;

    /**
     * @var float
     *
     * @ORM\Column(name="valormaximo", type="float", precision=10, scale=0, nullable=false)
     */
    private $valormaximo;

    /**
     * @var integer
     *
     * @ORM\Column(name="limiteReembolso", type="integer", nullable=false)
     */
    private $limitereembolso = '6';

    /**
     * @var string
     *
     * @ORM\Column(name="estado", type="string", length=1, nullable=true)
     */
    private $estado = 'A';

    /**
     * @var string
     *
     * @ORM\Column(name="descricao", type="text", nullable=true)
     */
    private $descricao;



    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set nome
     *
     * @param string $nome
     * @return TipoCredito
     */
    public function setNome($nome)
    {
        $this->nome = $nome;

        return $this;
    }

    /**
     * Get nome
     *
     * @return string 
     */
    public function getNome()
    {
        return $this->nome;
    }

    /**
     * Set valormaximo
     *
     * @param float $valormaximo
     * @return TipoCredito
     */
    public function setValormaximo($valormaximo)
    {
        $this->valormaximo = $valormaximo;

        return $this;
    }

    /**
     * Get valormaximo
     *
     * @return float 
     */
    public function getValormaximo()
    {
        return $this->valormaximo;
    }

    /**
     * Set limitereembolso
     *
     * @param integer $limitereembolso
     * @return TipoCredito
     */
    public function setLimitereembolso($limitereembolso)
    {
        $this->limitereembolso = $limitereembolso;

        return $this;
    }

    /**
     * Get limitereembolso
     *
     * @return integer 
     */
    public function getLimitereembolso()
    {
        return $this->limitereembolso;
    }

    /**
     * Set estado
     *
     * @param string $estado
     * @return TipoCredito
     */
    public function setEstado($estado)
    {
        $this->estado = $estado;

        return $this;
    }

    /**
     * Get estado
     *
     * @return string 
     */
    public function getEstado()
    {
        return $this->estado;
    }

    /**
     * Set descricao
     *
     * @param string $descricao
     * @return TipoCredito
     */
    public function setDescricao($descricao)
    {
        $this->descricao = $descricao;

        return $this;
    }

    /**
     * Get descricao
     *
     * @return string 
     */
    public function getDescricao()
    {
        return $this->descricao;
    }
    
    public function __toString() {
        return $this->getNome();
    }
}
