<?php

namespace Usoko\SIGBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * Tipopagamento
 *
 * @ORM\Table(name="tipopagamento", uniqueConstraints={@ORM\UniqueConstraint(name="nome", columns={"nome"}), @ORM\UniqueConstraint(name="codigo", columns={"tipo"})}, indexes={@ORM\Index(name="fk_Quota_Moeda1_idx", columns={"Moeda"})})
 * @ORM\Entity
 */
class Tipopagamento
{
    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $id;

    /**
     * @var string
     *
     * @ORM\Column(name="nome", type="string", length=50, nullable=false)
     */
    private $nome;

    /**
     * @var float
     *
     * @ORM\Column(name="valor", type="float", precision=10, scale=0, nullable=true)
     */
    private $valor;

    /**
     * @var string
     *
     * @ORM\Column(name="base", type="string", length=1, nullable=true)
     */
    private $base;

    /**
     * @var string
     *
     * @ORM\Column(name="frequencia", type="string", length=2, nullable=true)
     */
    private $frequencia = 'M';

    /**
     * @var string
     *
     * @ORM\Column(name="tipo", type="string", length=1, nullable=false)
     */
    private $tipo;

    /**
     * @var string
     *
     * @ORM\Column(name="descricao", type="string", length=50, nullable=true)
     */
    private $descricao;

    /**
     * @var \Moeda
     *
     * @ORM\ManyToOne(targetEntity="Moeda")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="Moeda", referencedColumnName="id")
     * })
     */
    private $moeda;



    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set nome
     *
     * @param string $nome
     * @return Tipopagamento
     */
    public function setNome($nome)
    {
        $this->nome = $nome;

        return $this;
    }

    /**
     * Get nome
     *
     * @return string 
     */
    public function getNome()
    {
        return $this->nome;
    }

    /**
     * Set valor
     *
     * @param float $valor
     * @return Tipopagamento
     */
    public function setValor($valor)
    {
        $this->valor = $valor;

        return $this;
    }

    /**
     * Get valor
     *
     * @return float 
     */
    public function getValor()
    {
        return $this->valor;
    }

    /**
     * Set base
     *
     * @param string $base
     * @return Tipopagamento
     */
    public function setBase($base)
    {
        $this->base = $base;

        return $this;
    }

    /**
     * Get base
     *
     * @return string 
     */
    public function getBase()
    {
        return $this->base;
    }

    /**
     * Set frequencia
     *
     * @param string $frequencia
     * @return Tipopagamento
     */
    public function setFrequencia($frequencia)
    {
        $this->frequencia = $frequencia;

        return $this;
    }

    /**
     * Get frequencia
     *
     * @return string 
     */
    public function getFrequencia()
    {
        return $this->frequencia;
    }

    /**
     * Set tipo
     *
     * @param string $tipo
     * @return Tipopagamento
     */
    public function setTipo($tipo)
    {
        $this->tipo = $tipo;

        return $this;
    }

    /**
     * Get tipo
     *
     * @return string 
     */
    public function getTipo()
    {
        return $this->tipo;
    }

    /**
     * Set descricao
     *
     * @param string $descricao
     * @return Tipopagamento
     */
    public function setDescricao($descricao)
    {
        $this->descricao = $descricao;

        return $this;
    }

    /**
     * Get descricao
     *
     * @return string 
     */
    public function getDescricao()
    {
        return $this->descricao;
    }

    /**
     * Set moeda
     *
     * @param \Usoko\SIGBundle\Entity\Moeda $moeda
     * @return Tipopagamento
     */
    public function setMoeda(\Usoko\SIGBundle\Entity\Moeda $moeda = null)
    {
        $this->moeda = $moeda;

        return $this;
    }

    /**
     * Get moeda
     *
     * @return \Usoko\SIGBundle\Entity\Moeda 
     */
    public function getMoeda()
    {
        return $this->moeda;
    }
    
    public function __toString() {
        return $this->nome;
    }
}
