<?php

namespace Usoko\SIGBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolverInterface;

class AssociadoType extends AbstractType {

    /**
     * @param FormBuilderInterface $builder
     * @param array $options
     */
    public function buildForm(FormBuilderInterface $builder, array $options) {
        $builder
                //->add('numero','text',array('label' => 'Número de Associado'))
                ->add('nMecanografico', 
                      'text', 
                       array(
                            'label' => 'Nº Mecanográfico',
                            'required' => false, 
                            'attr' => array(
                                'placeholder' => 'Nº Mecanográfico',
                                'pattern' => "\d{5}")
                           )
                        )
                        
                    
                
                
                ->add(
                        'pessoa', 
                        new PessoaType()
                      )
                      
                        
                
                ->add(
                        'orgao', 
                        null, 
                        array(
                            'label' => 'Orgão', 
                            'required' => true)
                        )
                //Antes Cargo agora Funcao
                
                ->add(
                        'cargo', 
                        null, 
                        array(
                            'label' => 'Função', 
                            'required' => true)
                        )
                //Antes Profissao agora Categoria
                ->add(
                        'profissao', 
                        null, 
                        array('label' => 'Categoria', 
                            'required' => true)
                        )
                
                ->add(
                        'salario',
                        'text', 
                        array(
                            'label' => 'Salário', 
                            'required' => true,
                            'attr' => array(
                                'pattern' => '[1-9][0-9.,]{0,}', 
                                'title' => 'Deve conter no  mínimo 3 digitos')
                            )
                        )
                
                ->add(
                        'dataAdmissao', 
                        'date', 
                        array(
                            'widget' => 'single_text', 
                            'label' => 'Data de Admissão na PN', 
                            'required' => true)
                        )
                
                ->add(
                        'anexo', 
                        'file', 
                        array(
                            'label' => 'Anexo', 
                            'required' => false)
                        )
                
                ->add(
                        'conta', 
                        new BancoContaType()
                        )
                
                ->add(
                        'status', 
                        'choice', 
                        array(
                            'label' => 'Status',
                            'required' => true, 
                            'choices' => array(
                                'A' => 'Activo', 
                                'I' => 'Inactivo',
                                'D' => 'Desvinculado',
                                 'R' => 'Reformado',
                                  'AD' => 'Adido',
                                   'F' => 'Falecido',

                             )
                            )
                        )
                // , 'F' => 'Falecido'
        ;
    }

    /**
     * @param OptionsResolverInterface $resolver
     */
    public function setDefaultOptions(OptionsResolverInterface $resolver) {
        $resolver->setDefaults(array(
            'data_class' => 'Usoko\SIGBundle\Entity\Associado'
        ));
    }

    /**
     * @return string
     */
    public function getName() {
        return 'usoko_sigbundle_associado';
    }

}
