<?php

namespace Usoko\SIGBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolverInterface;

class BancoInstituicaoType extends AbstractType
{
        /**
     * @param FormBuilderInterface $builder
     * @param array $options
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('sigla','text',array('label'=>'Sigla', 'required'=>true,
                'attr' => array('minlength' => 2, 'maxlength' => 50,
                    'pattern' => '[a-zA-Z]{2,20}', 'title' => 'Sem numeros, caracteres especiais ou vazio')))
                
            ->add('nome','text',array('label'=>'Nome ', 'required'=>true,
                'attr' => array('minlength' => 2, 'maxlength' => 50,
                    'pattern' => '([a-zA-ZáéíóúÁÉÍÓÚàèìòùÀÈÌÒÙãõÃÕâêîôûÂÊÎÔÛçÇ]|\s{2,})(([a-zA-ZáéíóúÁÉÍÓÚàèìòùÀÈÌÒÙãõÃÕâêîôûÂÊÎÔÛçÇ]|\s|[A-ZáéíóúÁÉÍÓÚàèìòùÀÈÌÒÙãõÃÕâêîôûÂÊÎÔÛçÇ][.])*)',
                    'title' => 'Sem numeros, caracteres esºeciais ou vazio')))
            ->add('descricao','textarea',array('label'=>'Descrição',
                'required'=>false, 'attr' => array('maxlength' => 100)))
        ;
    }
    
    /**
     * @param OptionsResolverInterface $resolver
     */
    public function setDefaultOptions(OptionsResolverInterface $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => 'Usoko\SIGBundle\Entity\BancoInstituicao'
        ));
    }

    /**
     * @return string
     */
    public function getName()
    {
        return 'usoko_sigbundle_bancoinstituicao';
    }
}
