<?php

namespace Usoko\SIGBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolverInterface;

class CartaoType extends AbstractType
{
        /**
     * @param FormBuilderInterface $builder
     * @param array $options
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('associado', null, array('label'=>'Associado', 'required'=>true))
            ->add('estado','choice',array('label'=>'Estado','choices'=>
                array('A'=>'Activado','D'=>'Desactivado'), 'required'=>true))
            ->add('dataEmissao','date',array('widget'=>'single_text','label'
                =>'Data de Emissão', 'required'=>true))
            ->add('dataExpiracao','date',array('widget'=>'single_text','label'=>
                'Data de Expiração', 'required'=>true))
            
            //->add('utilizador')
        ;
    }
    
    /**
     * @param OptionsResolverInterface $resolver
     */
    public function setDefaultOptions(OptionsResolverInterface $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => 'Usoko\SIGBundle\Entity\Cartao'
        ));
    }

    /**
     * @return string
     */
    public function getName()
    {
        return 'usoko_sigbundle_cartao';
    }
}
