<?php

namespace Usoko\SIGBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolverInterface;

class ContactoType extends AbstractType {

    /**
     * @param FormBuilderInterface $builder
     * @param array $options
     */
    public function buildForm(FormBuilderInterface $builder, array $options) {
        $builder
                ->add('tipocontacto', null, array('label' => 'Tipo de Contacto',
                    'required' => true))
                ->add('nome', 'text', array('label' => 'Contacto', 'required' => true,
                    'attr' => array('minlength' => 2, 'maxlength' => 60)))

        //->add('pessoa', null, array('label'=>'Associado', 'required'=>true))
        ;
    }

    /**
     * @param OptionsResolverInterface $resolver
     */
    public function setDefaultOptions(OptionsResolverInterface $resolver) {
        $resolver->setDefaults(array(
            'data_class' => 'Usoko\SIGBundle\Entity\Contacto'
        ));
    }

    /**
     * @return string
     */
    public function getName() {
        return 'usoko_sigbundle_contacto';
    }

}
