<?php

namespace Usoko\SIGBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolverInterface;

class CreditoPlafondType extends AbstractType
{
        /**
     * @param FormBuilderInterface $builder
     * @param array $options
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('ano', 'text', array('label' => 'Ano',
                'attr' => array('pattern' => '([0-9]{4})',
                    'minlength' => 4, 'maxlength' => 4, 
                    'title' => 'Sem caracteres especiais, letras ou vazio. Ex: 2015')))
            ->add('valorlimite', 'number', array('label' => 'Valor Limite',
                'attr' => array('pattern' => '([1-9][0-9.,]{1,})', 'minlength' => 1, 
                    'title' => 'Sem caracteres especiais, letras ou vazio.')))
            /*->add('valorconcedido', 'number', array('label' => 'Valor Concedido',
                'attr' => array('pattern' => '([0-9]{1,})',
                    'title' => 'Sem caracteres especiais, letras ou vazio.')))*/
            ->add('taxajuros', 'number', array('label' => 'Taxa de Juros (%)',
                'attr' => array('pattern' => '([0-9][0-9]?$|100)', 
                    'title' => 'Sem caracteres especiais, letras ou vazio.Ex: 10')))
            ->add('descricao', 'textarea', array('label' => 'Descrição', 'required' => false))
        ;
    }
    
    /**
     * @param OptionsResolverInterface $resolver
     */
    public function setDefaultOptions(OptionsResolverInterface $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => 'Usoko\SIGBundle\Entity\CreditoPlafond'
        ));
    }

    /**
     * @return string
     */
    public function getName()
    {
        return 'usoko_sigbundle_creditoplafond';
    }
}
