<?php

namespace Usoko\SIGBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolverInterface;

class CreditoRespostaType extends AbstractType {

    /**
     * @param FormBuilderInterface $builder
     * @param array $options
     */
    public function buildForm(FormBuilderInterface $builder, array $options) {
        $builder
                ->add('valor', 'number', array('label' => 'Valor', 'required' => true, 
                    'attr' => array(
                        'minlength' => 1, 
                        'pattern' => '[1-9][0-9]{0,}',
                        'title' => 'Valores numéricos')))
                //->add('valorMensal','number', array('required' => true, 'label' =>'Prestações Mensais', 'attr' => array('pattern' => '[1-9][0-9]{0,}', 'title' => 'Valores numéricos')))
                ->add('tempoAmortizacao','text', array('label' => 'Meses Amortização', 'required' => true,
                    'attr' => array('pattern' => '[1-9][0-9]{0,}')))
                
                ->add('moeda', null, array('label' => 'Moeda', 'required' => true))
                
                ->add('observacao', 'textarea', array('label' => 'Observação','required' => false, 
                    'attr' => array('maxlength' => 50)))
        ;
    }

    /**
     * @param OptionsResolverInterface $resolver
     */
    public function setDefaultOptions(OptionsResolverInterface $resolver) {
        $resolver->setDefaults(array(
            'data_class' => 'Usoko\SIGBundle\Entity\CreditoResposta'
        ));
    }

    /**
     * @return string
     */
    public function getName() {
        return 'usoko_sigbundle_creditoresposta';
    }

}
