<?php

namespace Usoko\SIGBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolverInterface;

class DistribuicaorendimentoType extends AbstractType
{
        /**
     * @param FormBuilderInterface $builder
     * @param array $options
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('ano', 'number', array(
		'label' => 'Ano', 'attr' => array(
			'pattern' => '[1-9][0-9][0-9][0-9]',
			'title' => 'Digite valores numéricos para o ano'
			)
		))
            ->add('valorrendimento', 'number', array(
		'label' => 'Valor de Rendimento', 
		'attr' => array(
			'pattern' => '[1-9][0-9.,]{0,}',
			'title' => 'Valores numéricos.')
                ))
            //->add('totalplanopensao')
            //->add('valorplanopensao')
            ->add('descricao', 'textarea', array(
                'required' => true,
		'label' => 'Descrição', 'attr' => array('maxlength' => 50)))
        ;
    }
    
    /**
     * @param OptionsResolverInterface $resolver
     */
    public function setDefaultOptions(OptionsResolverInterface $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => 'Usoko\SIGBundle\Entity\Distribuicaorendimento'
        ));
    }

    /**
     * @return string
     */
    public function getName()
    {
        return 'usoko_sigbundle_distribuicaorendimento';
    }
}
