<?php

namespace Usoko\SIGBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolverInterface;

class DocumentoidentificacaoType extends AbstractType {

    /**
     * @param FormBuilderInterface $builder
     * @param array $options
     */
    public function buildForm(FormBuilderInterface $builder, array $options) {
        $builder
                ->add('numero', 'text', array('label' => 'Número', 'required' => true))
                ->add('dataEmissao', 'date', array('widget' => 'single_text',
                    'label' => 'Data de Emissão', 'required' => true))
                ->add('dataExpiracao', 'date', array('widget' => 'single_text',
                    'label' => 'Data de Expiração', 'required' => true))
                ->add('localEmissao', 'text', array('label' => 'Local de emissão',
                    'required' => true, 'attr' => array('minlength' => 2, 'maxlength' => 100)))
                ->add('tipodocumento', null, array('label' => 'Tipo de Documento',
                    'required' => true))
        //->add('anexo', 'file', array('label'=>'Anexo', 'required'=>false))
        ;
    }

    /**
     * @param OptionsResolverInterface $resolver
     */
    public function setDefaultOptions(OptionsResolverInterface $resolver) {
        $resolver->setDefaults(array(
            'data_class' => 'Usoko\SIGBundle\Entity\Documentoidentificacao'
        ));
    }

    /**
     * @return string
     */
    public function getName() {
        return 'usoko_sigbundle_documentoidentificacao';
    }

}
