<?php

namespace Usoko\SIGBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolverInterface;

class FonteRendimentoType extends AbstractType
{
        /**
     * @param FormBuilderInterface $builder
     * @param array $options
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('nome', 'text', array('label' => 'Nome', 'required' => true,
                'attr' => array(
                    'pattern' => '([a-zA-ZáéíóúÁÉÍÓÚàèìòùÀÈÌÒÙãõÃÕâêîôûÂÊÎÔÛçÇ]|\s{2,})(([a-zA-ZáéíóúÁÉÍÓÚàèìòùÀÈÌÒÙãõÃÕâêîôûÂÊÎÔÛçÇ]|\s|[A-ZáéíóúÁÉÍÓÚàèìòùÀÈÌÒÙãõÃÕâêîôûÂÊÎÔÛçÇ][.])*)',
                    'minLength' => 2, 'maxLength' => 45,
                    'title' => 'Sem números ou caracteres especiais.'
                )))
                
            ->add('estado', 'choice', array('label' => 'Estado', 'required' => true, 
                'choices' => array('A' => 'Activa', 'D' => 'Desactiva')))
                
            ->add('descricao', 'textarea', array('label' => 'Descrição',
                'required' => false, 'attr' => array('maxLength' => 100)))
            
        ;
    }
    
    /**
     * @param OptionsResolverInterface $resolver
     */
    public function setDefaultOptions(OptionsResolverInterface $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => 'Usoko\SIGBundle\Entity\FonteRendimento'
        ));
    }

    /**
     * @return string
     */
    public function getName()
    {
        return 'usoko_sigbundle_fonterendimento';
    }
}
