<?php

namespace Usoko\SIGBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolverInterface;

class PagamentoType extends AbstractType {

    /**
     * @param FormBuilderInterface $builder
     * @param array $options
     */
    public function buildForm(FormBuilderInterface $builder, array $options) {

        $builder
                ->add('mesAno', 'text', array('label' => 'Mês-Ano', 'required' => true,
                    'attr' => array('placeholder' =>'Ex.: 02-2015','class' => 'form-control datepicker-month',
                        'pattern' => '([0-9]{2})-([0-9]{4})')))
                ->add('valor', 'number', array('label' => 'Valor', 'required' => true,
                    'attr' => array(
                        'pattern' => '[1-9][0-9.,]{1,}')))
                ->add('tipopagamento', null, array('label' => 'Tipo Pagamento', 'required' => true))
                ->add('bancoConta', null, array('label' => 'Banco', 'required' => true,
                    'query_builder' => function(\Doctrine\ORM\EntityRepository $er) {
                        return $er->createQueryBuilder('B')
                                ->where('B.tipo = :tipo ')
                                ->setParameter('tipo', 'U');
                    }
                ))
        //->add('estado','choice',array('choices'=>array('N' => 'Não Liquidada','L' =>'Liquidada'), 'label' => 'Estado','required' => true))
        //->add('percentagem', 'text', array('label'=>'Percentagem(%)', 'required'=>true))
        //->add('associado',null, array('label'=>'Associado', 'required'=>true))
        //->add('dataActual')
        ;
    }

    /**
     * @param OptionsResolverInterface $resolver
     */
    public function setDefaultOptions(OptionsResolverInterface $resolver) {
        $resolver->setDefaults(array(
            'data_class' => 'Usoko\SIGBundle\Entity\Pagamento'
        ));
    }

    /**
     * @return string
     */
    public function getName() {
        return 'usoko_sigbundle_pagamento';
    }

}
