<?php

namespace Usoko\SIGBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolverInterface;

class ParametrosimulacaoType extends AbstractType
{
        /**
     * @param FormBuilderInterface $builder
     * @param array $options
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('taxaRentabilidade','number', array('label'=>'Taxa de Rentabilidade', 'required'=>true,
                  'attr' => array('minlength' => 1, 'maxlength' => 5,'placeholder' => 'Ex. 3.25', 'onkeypress' => "return validaPercentagem(this, event, this.value);")))
            ->add('taxaRendSalarial','number', array('label'=>'Taxa de Crescimento Salarial', 'required'=>true,
                  'attr' => array('minlength' => 1, 'maxlength' => 5,'placeholder' => 'Ex. 4', 'onkeypress' => "return validaPercentagem(this, event, this.value);")))
            ->add('percContribuicao','number', array('label'=>'Percentagem de Contribuição', 'required'=>true,
                  'attr' => array('minlength' => 1, 'maxlength' => 5,'placeholder' => 'Ex. 6', 'onkeypress' => "return validaPercentagem(this, event, this.value);")))
            ->add('anosServico','number', array('label'=>'Total de Anos de Serviço', 'required'=>true,
                  'attr' => array('minlength' => 1, 'maxlength' => 5,'placeholder' => 'Ex. 60', 'onkeypress' => "return validaNumero(this, event, this.value);")))
           // ->add('dataCriacao', 'date', array('widget' => 'single_text', 'label' => 'Data de Criação', 'required'=>true))
            ->add('estado','choice', array('label' => 'Estado', 'choices' =>
                    array('A' => 'Activado', 'D' => 'Desactivado'), 'required' => true))
            ->add('observacao','textarea',array('label'=>'Observação', 'required'=>false, 'attr' => array('minlength' => 10, 'maxlength' => 500)))
        ;
    }
    
    /**
     * @param OptionsResolverInterface $resolver
     */
    public function setDefaultOptions(OptionsResolverInterface $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => 'Usoko\SIGBundle\Entity\Parametrosimulacao'
        ));
    }

    /**
     * @return string
     */
    public function getName()
    {
        return 'usoko_sigbundle_parametrosimulacao';
    }
}
