<?php

namespace Usoko\SIGBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolverInterface;

class PessoaType extends AbstractType {

    /**
     * @param FormBuilderInterface $builder
     * @param array $options
     */
    public function buildForm(FormBuilderInterface $builder, array $options) {
        $builder
                ->add('nome', 'text', array('label' => 'Nome Completo', 
                    'required'=>true,
                    'attr' =>array('placeholder' => 'Ex. Silvio Miguel',
                        'minlength'=>5, 'maxlength' => 100, 
                        'pattern' => '([a-zA-ZáéíóúÁÉÍÓÚàèìòùÀÈÌÒÙãõÃÕâêîôûÂÊÎÔÛçÇ]|\s{2,})(([a-zA-ZáéíóúÁÉÍÓÚàèìòùÀÈÌÒÙãõÃÕâêîôûÂÊÎÔÛçÇ]|\s|[A-ZáéíóúÁÉÍÓÚàèìòùÀÈÌÒÙãõÃÕâêîôûÂÊÎÔÛçÇ][.])*)')))
                ->add('genero', 'choice', array('required' => true,'label' => 'Gênero', 'choices' 
                    => array('M' => 'Masculino', 'F' => 'Feminino')))
                ->add('estadoCivil', 'choice', array('label' => 'Estado Civil', 
                    'choices' => array('S' => 'Solteiro(a)', 'C' => 'Casado(a)',
                    'D'=>'Divorciado(a)','V'=>'Viúvo(a)')))
                ->add('dataNascimento', 'date', array('widget' => 'single_text', 'label' => 'Data de Nascimento', 'required'=>true))
                ->add('foto', 'file', array('label'=>'Foto', 'required'=>false))
                ->add('tipo', 'choice', array('label' => 'Tipo', 'required'=>true, 'choices' => 
                    array('A' => 'Associado', 'D' => 'Dependente')))
                ->add('endereco', 'collection', array('required'=>true,'type' => new EnderecoType(), 'allow_add' => true, 'allow_delete' => true, 'by_reference' => false))
                ->add('contacto', 'collection', array('required'=>true,'type' => new ContactoType(), 'allow_add' => true, 'allow_delete' => true, 'by_reference' => false))
                ->add('documentoidentificacao', 'collection', array('required'=>true,'type' => new DocumentoidentificacaoType(), 'allow_add' => true, 'allow_delete' => true, 'by_reference' => false))
                
        ;
    }

    /**
     * @param OptionsResolverInterface $resolver
     */
    public function setDefaultOptions(OptionsResolverInterface $resolver) {
        $resolver->setDefaults(array(
            'data_class' => 'Usoko\SIGBundle\Entity\Pessoa'
        ));
    }

    /**
     * @return string
     */
    public function getName() {
        return 'usoko_sigbundle_pessoa';
    }

}
