<?php

namespace Usoko\SIGBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolverInterface;

class PpDesvinculacaoPercentagemType extends AbstractType
{
        /**
     * @param FormBuilderInterface $builder
     * @param array $options
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('inicio', "number", array('label' => 'Início', 'required' => false,
                'attr' =>array('placeholder' => 'Ex: 10')))
                
            ->add('fim', "number", array('label' => 'Fim', 'required' => false,
                'attr' =>array('placeholder' => 'Ex: 10')))
                
            ->add('percentagem', "number", array('label' => 'Percentagem (%)','required' => true, 
                'attr' => array(
                    'pattern' => '[0-9][0-9]?$|100', 
                    'title' => 'Valores numéricos de 0 a 100'
                    )
                ))
        ;
    }
    
    /**
     * @param OptionsResolverInterface $resolver
     */
    public function setDefaultOptions(OptionsResolverInterface $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => 'Usoko\SIGBundle\Entity\PpDesvinculacaoPercentagem'
        ));
    }

    /**
     * @return string
     */
    public function getName()
    {
        return 'usoko_sigbundle_ppdesvinculacaopercentagem';
    }
}
