<?php

namespace Usoko\SIGBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolverInterface;

class SubsidioType extends AbstractType
{
        /**
     * @param FormBuilderInterface $builder
     * @param array $options
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('tipo', 'text', array('label'=>'Subsídio', 'required'=>true,
                'attr' => 
                array('pattern' => '([a-zA-ZáéíóúÁÉÍÓÚàèìòùÀÈÌÒÙãõÃÕâêîôûÂÊÎÔÛçÇ]|\s{2,})(([a-zA-ZáéíóúÁÉÍÓÚàèìòùÀÈÌÒÙãõÃÕâêîôûÂÊÎÔÛçÇ]|\s|[A-ZáéíóúÁÉÍÓÚàèìòùÀÈÌÒÙãõÃÕâêîôûÂÊÎÔÛçÇ][.])*)',
                'title' => 'Sem espaços em branco ou caracteres especiais',
                    'minlength' => 2, 'maxlength' =>100)))
            ->add('valorMaximoTitular', 'number', array('label'=>'V. Máximo Titular',
                'required'=>true, 
                'attr' => array('pattern' => '[1-9][0-9.,]{0,}', 
                    'title' => 'Valores numéricos')))
            ->add('valorMaximoDependente', 'number', array('label'=>'V. Máximo Dependente',
                'required'=>true,
                'attr' => array('pattern' => '[1-9][0-9.,]{0,}', 
                    'title' => 'Valores numéricos')))
            ->add('categoria', null, array('label'=>'Categoria', 'required'=>true))
            ->add('moeda', null, array('label'=>'Moeda', 'required'=>true))
        ;
    }
    
    /**
     * @param OptionsResolverInterface $resolver
     */
    public function setDefaultOptions(OptionsResolverInterface $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => 'Usoko\SIGBundle\Entity\Subsidio'
        ));
    }

    /**
     * @return string
     */
    public function getName()
    {
        return 'usoko_sigbundle_subsidio';
    }
}
