<?php

namespace Usoko\SIGBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolverInterface;

class TipoBeneficioType extends AbstractType {

    /**
     * @param FormBuilderInterface $builder
     * @param array $options
     */
    public function buildForm(FormBuilderInterface $builder, array $options) {
        $builder
                ->add('nome', 'text', array('label' => 'Beneficio', 'required' => true,
                    'attr' => array(
                        'pattern' => '([a-zA-ZáéíóúÁÉÍÓÚàèìòùÀÈÌÒÙãõÃÕâêîôûÂÊÎÔÛçÇ]|\s{2,})(([a-zA-ZáéíóúÁÉÍÓÚàèìòùÀÈÌÒÙãõÃÕâêîôûÂÊÎÔÛçÇ]|\s|[A-ZáéíóúÁÉÍÓÚàèìòùÀÈÌÒÙãõÃÕâêîôûÂÊÎÔÛçÇ][.])*)',
                        'title' => 'Sem caracteres especiais ou números.',
                        'minLength' => 2, 'maxLength' => 45
            )))
                ->add('tipo', 'choice', array('label' => 'Tipo', 'required' => true, 'choices' => array('R' => 'Reforma', 'M' => 'Morte', 'I' => 'Invalidez')))
                ->add('descricao', 'textarea', array('label' => 'Descrição', 'attr' => array(
                        'maxLength' => 45
            )))
        ;
    }

    /**
     * @param OptionsResolverInterface $resolver
     */
    public function setDefaultOptions(OptionsResolverInterface $resolver) {
        $resolver->setDefaults(array(
            'data_class' => 'Usoko\SIGBundle\Entity\TipoBeneficio'
        ));
    }

    /**
     * @return string
     */
    public function getName() {
        return 'usoko_sigbundle_tipobeneficio';
    }

}
