<?php

namespace Usoko\SIGBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolverInterface;

class TipoCreditoType extends AbstractType
{
        /**
     * @param FormBuilderInterface $builder
     * @param array $options
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('nome', 'text', array('label' => 'Crédito', 'required' => true,
                'attr' => array('minlength'=> 2, 'maxlength'=> 50,
                    'pattern' => '([a-zA-ZáéíóúÁÉÍÓÚàèìòùÀÈÌÒÙãõÃÕâêîôûÂÊÎÔÛçÇ]|\s{2,})(([a-zA-ZáéíóúÁÉÍÓÚàèìòùÀÈÌÒÙãõÃÕâêîôûÂÊÎÔÛçÇ]|\s|[A-ZáéíóúÁÉÍÓÚàèìòùÀÈÌÒÙãõÃÕâêîôûÂÊÎÔÛçÇ][.])*)',
                    'title' => 'Sem caracteres especiais ou números.')))
            ->add('valormaximo', 'number', array('label' => 'Valor Máximo', 'required' => true,
                'attr' => array('pattern' => '([1-9]{1,}[0-9.,]{0,})', 'title' => 'Valores numéricos.')))
            ->add('limitereembolso', 'number', array('label' => 'Limite de Reembolso (Meses)', 'required' => true,
                'attr' => array('pattern' => '([1-9]{1,}[0-9]{0,})', 'title' => 'Valores numéricos.')))
            //->add('estado', 'text', array('label' => 'Estado', 'required' => true))
            ->add('descricao', 'textarea', array('label' => 'Descrição', 'required' => false))
        ;
    }
    
    /**
     * @param OptionsResolverInterface $resolver
     */
    public function setDefaultOptions(OptionsResolverInterface $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => 'Usoko\SIGBundle\Entity\TipoCredito'
        ));
    }

    /**
     * @return string
     */
    public function getName()
    {
        return 'usoko_sigbundle_tipocredito';
    }
}
