<?php

namespace Usoko\SIGBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolverInterface;

class TipocontactoType extends AbstractType
{
        /**
     * @param FormBuilderInterface $builder
     * @param array $options
     */
    public function buildForm(FormBuilderInterface $builder, array $options)
    {
        $builder
            ->add('nome', 'text', array('label'=>'Tipo de Contacto', 
                'required'=>true, 'attr' => array('pattern' => 
                    '([a-zA-Z]{2,}|\s)(([a-zA-Z]|\s|[A-Z][.])*)',
                    'title'=> 'Sem caracteres especiais, números ou vazio')))
            ->add('descricao', 'textarea', array('label'=>'Descrição', 'required'=>false,
                'attr' => array('maxlenht' => 100)))
        ;
    }
    
    /**
     * @param OptionsResolverInterface $resolver
     */
    public function setDefaultOptions(OptionsResolverInterface $resolver)
    {
        $resolver->setDefaults(array(
            'data_class' => 'Usoko\SIGBundle\Entity\Tipocontacto'
        ));
    }

    /**
     * @return string
     */
    public function getName()
    {
        return 'usoko_sigbundle_tipocontacto';
    }
}
