<?php

namespace Usoko\SIGBundle\Form;

use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolverInterface;

class UtilizadorType extends AbstractType {

    /**
     * @param FormBuilderInterface $builder
     * @param array $options
     */
    public function buildForm(FormBuilderInterface $builder, array $options) {
        $builder
                ->add('pessoa', new PessoaType())
                ->add('username', 'text', array('label' => 'Nome de Utilizador', 'required' => true,
                    'attr' => array('pattern' => '([a-zA-Z]{2,})(([a-zA-Z]|-|.|_|[A-Z][.])*)',
                        'title' => 'Padrão: nome.outronome ou nome-outronome ou nome_outronome',
                        'minlength' => 5, 'maxlength' => 50)))
                //->add('password', 'password', array('label' => 'Senha', 'required' => true, 'attr' => array('minlength' => 8)))
                ->add('password', 'repeated', array(
                    'attr' => array('minlength' => 8, 'maxlength' => 20),
                    'type' => 'password',
                    'invalid_message' => 'As password não coincidem.',
                    'options' => array('attr' => array('class' => 'password-field')),
                    'required' => true,
                    'first_options' => array('label' => 'Password', 'attr' => array('minlength' => 8)),
                    'second_options' => array('label' => 'Repetir Password')))
                ->add('isactive', 'choice', array('label' => 'Estado', 'choices' =>
                    array(1 => 'Activa', 0 => 'Desactivada'), 'required' => true))
                ->add('funcao', null, array('label' => 'Função', 'required' => true))
        ;
    }

    /**
     * @param OptionsResolverInterface $resolver
     */
    public function setDefaultOptions(OptionsResolverInterface $resolver) {
        $resolver->setDefaults(array(
            'data_class' => 'Usoko\SIGBundle\Entity\Utilizador'
        ));
    }

    /**
     * @return string
     */
    public function getName() {
        return 'usoko_sigbundle_utilizador';
    }

}
