<?php

namespace Usoko\SIGBundle\General;

class AuditoriaGeneral {
    
    public static function auditar($obj, $em, $entity, $tabela, $tipoOperacao, $descricao) {
        //Inicio da operação
        $operacao = new \Usoko\SIGBundle\Entity\Operacao();
        $operacao->setTabela($tabela);
        $operacao->setOperacao($tipoOperacao);
        $operacao->setDescricao($descricao);
        $operacao->setData(\Usoko\SIGBundle\General\DataGeneral::tempoGeral());
        $utilizador = $obj->get('security.context')->getToken()->getUser();
        if (!is_object($utilizador)) {
            return $obj->redirect($obj->generateUrl('login'));
        }
        $operacao->setUtilizador($utilizador);
        $operacao->setRegisto($entity->getId());
        $operacao->setDado($entity);
        
        $em->persist($operacao);
        $em->flush();
    }
}
