<?php

namespace Usoko\SIGBundle\General;


class FuncaoGeneral {
  
    
    public static function retornaMes($mes) {
        $retorno=null;
        switch ($mes) {
            case 'Janeiro':     $retorno=1; break;
            case 'Fevereiro':   $retorno=2; break;
            case 'Março':       $retorno=3; break;
            case 'Abril':       $retorno=4; break;
            case 'Maio':        $retorno=5; break;
            case 'Junho':       $retorno=6; break;
            case 'Julho':       $retorno=7; break;
            case 'Agosto':      $retorno=8; break;
            case 'Setembro':    $retorno=9; break;
            case 'Outubro':     $retorno=10; break;
            case 'Novembro':    $retorno=11; break;
            case 'Dezembro':    $retorno=12; break;
            default: $retorno=null;break;
        }
        return $retorno;
    }
    
    
    public static function object2Array($obj) {
        $a = array();
        foreach ($obj as $k => $valor)
            $a[$k] = (is_array($valor) || is_object($valor)) ? object2Array($valor) : $valor;
        return $a;
    }
	
	    public static function abreviaNome($nome, $max = 34) {
        $nome = trim($nome);
        $tamanho = strlen($nome);
        if ($tamanho > $max) {
            $nomes = split(" ", $nome);
            $ultimo = array_pop($nomes);
            $nomes = array_reverse($nomes);
            $pri = array_pop($nomes);
            $nomes = array_reverse($nomes);

            $tamanho = strlen($pri) + strlen($ultimo) + 1;
            $nomes_abreviados = "";

            foreach ($nomes as $n) {
                $tm = strlen($n) + $tamanho + 1;
                if (($tm) <= $max) {
                    $nomes_abreviados.=' ' . $n;
                    $tamanho += strlen($n);
                } else {
                    $nomes_abreviados.=' ' . substr($n, 0, 1) . '.';
                    $tamanho+=3;
                }
            }

            $nome_abrev = $pri . " " . $nomes_abreviados . " " . $ultimo;
        } else {
            $nome_abrev = $nome;
        }
        return trim($nome_abrev);
    }
	
	
	public static function dataINDatetime($datetime, $mod = 1) {
        $array = (array) $datetime;
        $data = explode(' ', $array['date']);
        if ($mod == DataGeneral::DDMMYY) {
            return isset($data[0]) ? $data[0] : '';
        } elseif ($mod == DataGeneral::DDMMYYHHMMSS) {
            return isset($array['date']) ? $array['date'] : '';
        }
    }

    public static function valorPorExtenso($valor = 0, $bolExibirMoeda = true, $bolPalavraFeminina = false) {

        $valor = self::removerFormatacaoNumero($valor);

        $singular = null;
        $plural = null;

        if ($bolExibirMoeda) {
            $singular = array("centavo", "kwanza", "mil", "milhão", "bilhão", "trilhão", "quatrilhão");
            $plural = array("centavos", "kwanzas", "mil", "milhões", "bilhões", "trilhões", "quatrilhões");
        } else {
            $singular = array("", "", "mil", "milhão", "bilhão", "trilhão", "quatrilhão");
            $plural = array("", "", "mil", "milhões", "bilhões", "trilhões", "quatrilhões");
        }

        $c = array("", "cem", "duzentos", "trezentos", "quatrocentos", "quinhentos", "seiscentos", "setecentos", "oitocentos", "novecentos");
        $d = array("", "dez", "vinte", "trinta", "quarenta", "cinquenta", "sessenta", "setenta", "oitenta", "noventa");
        $d10 = array("dez", "onze", "doze", "treze", "quatorze", "quinze", "dezesseis", "dezesete", "dezoito", "dezenove");
        $u = array("", "um", "dois", "três", "quatro", "cinco", "seis", "sete", "oito", "nove");


        if ($bolPalavraFeminina) {

            if ($valor == 1) {
                $u = array("", "uma", "duas", "três", "quatro", "cinco", "seis", "sete", "oito", "nove");
            } else {
                $u = array("", "um", "duas", "três", "quatro", "cinco", "seis", "sete", "oito", "nove");
            }


            $c = array("", "cem", "duzentas", "trezentas", "quatrocentas", "quinhentas", "seiscentas", "setecentas", "oitocentas", "novecentas");
        }


        $z = 0;

        $valor = number_format($valor, 2, ".", ".");
        $inteiro = explode(".", $valor);

        for ($i = 0; $i < count($inteiro); $i++) {
            for ($ii = mb_strlen($inteiro[$i]); $ii < 3; $ii++) {
                $inteiro[$i] = "0" . $inteiro[$i];
            }
        }

        // $fim identifica onde que deve se dar junção de centenas por "e" ou por "," ;)
        $rt = null;
        $fim = count($inteiro) - ($inteiro[count($inteiro) - 1] > 0 ? 1 : 2);
        for ($i = 0; $i < count($inteiro); $i++) {
            $valor = $inteiro[$i];
            $rc = (($valor > 100) && ($valor < 200)) ? "cento" : $c[$valor[0]];
            $rd = ($valor[1] < 2) ? "" : $d[$valor[1]];
            $ru = ($valor > 0) ? (($valor[1] == 1) ? $d10[$valor[2]] : $u[$valor[2]]) : "";

            $r = $rc . (($rc && ($rd || $ru)) ? " e " : "") . $rd . (($rd && $ru) ? " e " : "") . $ru;
            $t = count($inteiro) - 1 - $i;
            $r .= $r ? " " . ($valor > 1 ? $plural[$t] : $singular[$t]) : "";
            if ($valor == "000")
                $z++;
            elseif ($z > 0)
                $z--;

            if (($t == 1) && ($z > 0) && ($inteiro[0] > 0))
                $r .= ( ($z > 1) ? " de " : "") . $plural[$t];

            if ($r)
                $rt = $rt . ((($i > 0) && ($i <= $fim) && ($inteiro[0] > 0) && ($z < 1)) ? ( ($i < $fim) ? ", " : " e ") : " ") . $r;
        }

        $rt = mb_substr($rt, 1);

        return(ucfirst($rt) ? ucfirst(trim($rt)) : "zero");
    }

    public static function removerFormatacaoNumero($strNumero) {

        $strNumero = trim(str_replace("R$", null, $strNumero));

        $vetVirgula = explode(",", $strNumero);
        if (count($vetVirgula) == 1) {
            $acentos = array(".");
            $resultado = str_replace($acentos, "", $strNumero);
            return $resultado;
        } else if (count($vetVirgula) != 2) {
            return $strNumero;
        }

        $strNumero = $vetVirgula[0];
        $strDecimal = mb_substr($vetVirgula[1], 0, 2);

        $acentos = array(".");
        $resultado = str_replace($acentos, "", $strNumero);
        $resultado = $resultado . "." . $strDecimal;

        return $resultado;
    }

    public static function converteDataParaDiaMesAno($data) {
        
        $retornoData = "";
        $ano = substr($data, 0, 4);
        $mes = substr($data, 5, 2);
        $dia = substr($data, 8, 8);

        $retornoData = $dia."/".$mes."/".$ano;
        return $retornoData;
    }

    
}
