<?php

namespace Usoko\SIGBundle\General;

use \TCPDF;

class NasaPdf extends TCPDF {

    protected $valortotal;   //valortotal 
    protected $taxa;         //percentagem ou taxa de juros
    protected $anos;         //número de anos a amortizar o crédito
    protected $npmts;        //número de pagamentos 
    protected $mtaxa;        //mensal pagamento com taxa
    protected $tpmnt;        //total valortotal 
    protected $tint;         //total interest paid on the loan
    protected $pmnt;
    protected $obj;

    public function __construct($obj, $valortotal = null, $taxa = null, $anos = null) {

        $this->valortotal = $valortotal;
        $this->taxa = $taxa;
        $this->anos = $anos;
        $this->obj = $obj;
        parent::__construct($orientation = 'P', $unit = 'mm', $format = 'A4', $unicode = true, $encoding = 'UTF-8', $diskcache = false, $pdfa = false);

        $this->AddPage();
        $this->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
    }

    public function Header() {
        //Marca De agua
        $image_file = K_PATH_IMAGES . 'logo_marcaDagua.png';
        // Render the image
        //$this->Image($image_file, DTlarg, DstDown, TAMLarg, Tam ALt, '', '', '', false, 300, '', false, false, 0);

        $this->Image($image_file, 10, 90, 190, 100, '', '', '', false, 300, '', false, false, 0);
        // Set the starting point for the page content
        $this->setPageMark();


        //$em = $this->getDoctrine()->getManager();
        $image_file = K_PATH_IMAGES . 'logo.png';
        //$this->Image($image_file, $x, $y, $w, $h, $type, $link, $align, $resize, $dpi)
        // $this->Image($image_file, 96, 10, 17, '', 'png', '', 'T', false, 300, '', false, false, 0, false, false, false);
        $this->Image($image_file, 10, 10, 20, '', 'png', '', 'T', FALSE, 300, '', FALSE, FALSE, 0, FALSE, FALSE, FALSE);
        $texto1 = utf8_encode(utf8_decode('República de Angola'));
        $texto2 = utf8_encode(utf8_decode('Associação Mutualista'));
        $texto3 = utf8_encode(utf8_decode(''));
        $this->Ln(7);
//Fonte
        $this->SetFont('times', 'B', 12);
        $this->SetFont('helvetica', 'B', 12);
//Titulo
        $this->cell(20, '', '', 0, 0, 'L', 0, '', 0, false, 'T', 'M');
        $this->cell(170, 5, $texto2, 0, 1, 'L', 0, '', 0, false, 'T', 'M');

        /**
          $this->Cell(0, 10, $texto1, 0, false, 'L', 0, '', 0, false, 'T', 'M');
          $this->Ln(5);
          $this->Cell(0, 10, $texto2, 0, false, 'L', 0, '', 0, false, 'T', 'M');
          $this->Ln(5);
          $this->Cell(0, 10, $texto3, 0, false, 'L', 0, '', 0, false, 'T', 'M');
         * */
        $this->Ln(10);
        $texto = '<b></b>';
        $this->SetFont('times', 9);
        $this->SetFont('helvetica', '', 9);
        $texto = '<u>' . $texto . '</u>';
        $this->writeHTML($texto . $this->Ln(8), TRUE, FALSE, FALSE, FALSE, 'C');
        $this->Ln(5);
    }

    public function corpoQuota($lista, $inicio, $fim, $nomeassociado) {
        $this->SetY(55);
        $this->Ln(15);
        $this->Ln(5);

        $ano1 = substr($inicio, 0, 4);
        $mes1 = substr($inicio, 5, 2);
        $dia1 = substr($inicio, 8, 8);

        $ano2 = substr($fim, 0, 4);
        $mes2 = substr($fim, 5, 2);
        $dia2 = substr($fim, 8, 8);

        $inicio = $dia1 . "/" . $mes1 . "/" . $ano1;
        $fim = $dia2 . "/" . $mes2 . "/" . $ano2;

        $this->SetFont('times', 9);
        $w = array(60, 50, 70, 50, 70, 30, 30);

        $this->SetFont('helvetica', 'B', 12);
        $this->Cell(190, 6, 'Extracto dos Pagamentos de Quota', 1, 0, 'C', 0);
        $this->Ln(12);
        $this->SetFont('helvetica', '', 10);
        $this->writeHTML("Vimos por este meio apresentar à V/Excia.(s) " . '<b>' . " $nomeassociado " . '</b>' . " , o extracto dos pagamentos da conta da Usoko, 
		
		da qual é tem feito pagamentos de quotas , para os movimentos efectuados no período de " . $inicio . " à " . $fim . ".", TRUE, FALSE, FALSE, FALSE, 'J');
        $this->Ln(8);

        if (!$lista) {
            $this->Ln(2);
            $this->SetFont('helvetica', 'B', 10);
            $this->SetFillColor(199, 196, 186);

            $this->Cell($w[0], 6, 'Valor (Akz)', 1, 0, 'C', 1);
            $this->Cell($w[1], 6, 'Mês-Ano referente', 1, 0, 'C', 1);
            $this->Cell($w[2], 6, 'Data de Pagamento', 1, 0, 'C', 1);
            $this->Ln();

            $this->SetFont('helvetica', 'B', 16);
            $this->Cell(190, 6, "Sem dados para apresentar", 1, 0, 'C', 0);
        } else {
            $this->Ln(2);
            $this->SetFillColor(199, 196, 186);
            $this->SetFont('helvetica', 'B', 10);
            $this->Cell(10, 6, '#', 1, 0, 'C', 1);
            $this->Cell($w[0], 6, 'Valor (Akz)', 1, 0, 'C', 1);
            $this->Cell($w[1], 6, 'Mês-Ano referente', 1, 0, 'C', 1);
            $this->Cell($w[2], 6, 'Data de Pagamento', 1, 0, 'C', 1);
            $this->Ln();

            $this->SetFont('helvetica', '', 10);


            $conta = 0;
            $cumulo = 0;
            foreach ($lista as $vector) {
                $conta++;
                if ($conta % 2 == 0) {
                    $this->SetFillColor(248, 248, 248);
                } else {
                    $this->SetFillColor(255, 255, 255);
                }

                $cumulo = $cumulo + $vector->getValor();
                $this->Cell(10, 6, $conta, 1, 0, 'C', 1);
                $this->Cell($w[0], 6, number_format($vector->getValor(), 2, ',', '.'), 1, 0, 'L', 1);
                $this->Cell($w[1], 6, $vector->getMesAno(), 1, 0, 'C', 1);
                $this->Cell($w[2], 6, $vector->getDataActual()->format('d/m/Y'), 1, 0, 'C', 1);
                $this->Ln();
            }
            $this->SetFont('helvetica', 'B', 10);
            $this->Cell(190, 6, 'Valor acumulado: ' . number_format($cumulo, 2, ',', '.') . " Akz ", 1, 0, 'R', 0);
        }
    }

    public function corpoCredito($lista, $inicio, $fim, $nomeassociado) {

        $this->SetY(55);
        $this->Ln(15);
        $this->Ln(5);

        $this->SetFont('times', 9);

        $ano1 = substr($inicio, 0, 4);
        $mes1 = substr($inicio, 5, 2);
        $dia1 = substr($inicio, 8, 8);

        $ano2 = substr($fim, 0, 4);
        $mes2 = substr($fim, 5, 2);
        $dia2 = substr($fim, 8, 8);

        $inicio = $dia1 . "/" . $mes1 . "/" . $ano1;
        $fim = $dia2 . "/" . $mes2 . "/" . $ano2;

        $w = array(60, 50, 70, 50, 70, 30, 30);

        $this->SetFont('helvetica', 'B', 12);
        $this->Cell(190, 6, 'Extracto dos Pagamentos de Crédito', 1, 0, 'C', 0);
        $this->Ln(12);
        $this->SetFont('helvetica', '', 10);
        $this->writeHTML("Vimos por este meio apresentar à V/Excia.(s) " . '<b>' . " $nomeassociado " . '</b>' . " , o extracto dos pagamentos da conta da Usoko, 
		
		da qual é tem feito pagamentos de créditos , para os movimentos efectuados no período de " . $inicio . " à " . $fim . ".", TRUE, FALSE, FALSE, FALSE, 'J');
        $this->Ln(8);

        if (!$lista) {
            $this->Ln(2);
            $this->SetFillColor(199, 196, 186);
            $this->SetFont('helvetica', 'B', 10);
            $this->Cell(10, 6, '#', 1, 0, 'C', 1);
            $this->Cell($w[0], 6, 'Valor (Akz)', 1, 0, 'C', 1);
            $this->Cell($w[1], 6, 'Mês-Ano referente', 1, 0, 'C', 1);
            $this->Cell($w[2], 6, 'Data de Pagamento', 1, 0, 'C', 1);
            $this->Ln();

            $this->SetFont('helvetica', 'B', 16);
            $this->Cell(190, 6, "Sem dados para apresentar", 1, 0, 'C', 0);
        } else {
            $this->Ln(2);
            $this->SetFillColor(199, 196, 186);
            $this->SetFont('helvetica', 'B', 10);
            $this->Cell(10, 6, "#", 1, 0, 'C', 1);
            $this->Cell($w[0], 6, 'Valor (Akz)', 1, 0, 'C', 1);
            $this->Cell($w[1], 6, 'Mês-Ano referente', 1, 0, 'C', 1);
            $this->Cell($w[2], 6, 'Data de Pagamento', 1, 0, 'C', 1);
            $this->Ln();

            $this->SetFont('helvetica', '', 10);


            $conta = 0;
            foreach ($lista as $vector) {
                $conta++;
                if ($conta % 2 == 0) {
                    $this->SetFillColor(248, 248, 248);
                } else {
                    $this->SetFillColor(255, 255, 255);
                }
                $this->Cell(10, 6, $conta, 1, 0, 'C', 1);
                $this->Cell($w[0], 6, number_format($vector->getValor(), 2, ',', '.'), 1, 0, 'L', 1);
                $this->Cell($w[1], 6, $vector->getMesAno(), 1, 0, 'C', 1);
                $this->Cell($w[2], 6, $vector->getDataActual()->format('d/m/Y'), 1, 0, 'C', 1);
                $this->Ln();
            }
        }
    }

    public function corpoExtratoGeral($lista, $inicio, $fim, $nomeassociado) {

        $this->SetY(55);
        $this->Ln(15);
        $this->Ln(5);

        $this->SetFont('times', 9);

        $ano1 = substr($inicio, 0, 4);
        $mes1 = substr($inicio, 5, 2);
        $dia1 = substr($inicio, 8, 8);

        $ano2 = substr($fim, 0, 4);
        $mes2 = substr($fim, 5, 2);
        $dia2 = substr($fim, 8, 8);

        $inicio = $dia1 . "/" . $mes1 . "/" . $ano1;
        $fim = $dia2 . "/" . $mes2 . "/" . $ano2;

        $w = array(60, 50, 70, 50, 70, 30, 30);

        $this->SetFont('helvetica', 'B', 12);
        $this->Cell(190, 6, 'Extracto Geral dos Pagamentos', 1, 0, 'C', 0);
        $this->Ln(12);
        $this->SetFont('helvetica', '', 10);
        $this->writeHTML("Vimos por este meio apresentar à V/Excia.(s) " . '<b>' . " $nomeassociado " . '</b>' . " , o extracto dos pagamentos da conta da Usoko, 
		
		da qual é tem feito pagamentos de créditos , para os movimentos efectuados no período de " . $inicio . " à " . $fim . ".", TRUE, FALSE, FALSE, FALSE, 'J');
        $this->Ln(8);

        if (!$lista) {
            $this->Ln(2);
            $this->SetFillColor(199, 196, 186);
            $this->SetFont('helvetica', 'B', 10);
            $this->Cell(10, 6, '#', 1, 0, 'C', 1);
            $this->Cell(35, 6, 'Tipo de Pagamento', 1, 0, 'C', 1);
            $this->Cell(35, 6, 'Valor (Akz)', 1, 0, 'C', 1);
            $this->Cell(35, 6, 'Mês-Ano referente', 1, 0, 'C', 1);
            $this->Cell(35, 6, 'Data de Pagamento', 1, 0, 'C', 1);
            $this->Cell(40, 6, 'Estado', 1, 0, 'C', 1);
            $this->Ln();

            $this->SetFont('helvetica', 'B', 16);
            $this->Cell(190, 6, "Sem dados para apresentar", 1, 0, 'C', 0);
        } else {
            $this->Ln(2);
            $this->SetFillColor(199, 196, 186);
            $this->SetFont('helvetica', 'B', 10);
            $this->Cell(10, 6, "#", 1, 0, 'C', 1);
            $this->Cell(35, 6, 'Tipo de Pagamento', 1, 0, 'C', 1);
            $this->Cell(35, 6, 'Valor (Akz)', 1, 0, 'C', 1);
            $this->Cell(35, 6, 'Mês-Ano referente', 1, 0, 'C', 1);
            $this->Cell(35, 6, 'Data de Pagamento', 1, 0, 'C', 1);
            $this->Cell(40, 6, 'Estado', 1, 0, 'C', 1);

            $this->Ln();

            $this->SetFont('helvetica', '', 10);


            $conta = 0;
            foreach ($lista as $vector) {
                $conta++;
                if ($conta % 2 == 0) {
                    $this->SetFillColor(248, 248, 248);
                } else {
                    $this->SetFillColor(255, 255, 255);
                }
                $this->Cell(10, 6, $conta, 1, 0, 'C', 1);

                $tipoPaga = $vector->getTipoPagamento()->getTipo();
                if ($tipoPaga == 'C') {
                    $tipoPagamento = "Crédito";
                } else if ($tipoPaga == 'J') {
                    $tipoPagamento = "Jóia";
                } else if ($tipoPaga == 'Q') {
                    $tipoPagamento = "Quota";
                } else if ($tipoPaga == 'PP') {
                    $tipoPagamento = "Plano de pensão";
                } else {
                    $tipoPagamento = "";
                }

                $this->Cell(35, 6, $tipoPagamento, 1, 0, 'L', 1);
                $this->Cell(35, 6, number_format($vector->getValor(), 2, ',', '.'), 1, 0, 'L', 1);
                $this->Cell(35, 6, $vector->getMesAno(), 1, 0, 'C', 1);
                $this->Cell(35, 6, $vector->getDataActual()->format('d/m/Y'), 1, 0, 'C', 1);
                $this->Cell(40, 6, $vector->getEstado() == 'L' ? "Liquidado" : "Não liquidado", 1, 0, 'C', 1);
                $this->Ln();
            }
        }
    }

    public function corpoPlano($lista, $inicio, $fim, $nomeassociado) {
        $this->SetY(55);
        $this->Ln(15);
        $this->Ln(5);

        $this->SetFont('times', 9);

        $ano1 = substr($inicio, 0, 4);
        $mes1 = substr($inicio, 5, 2);
        $dia1 = substr($inicio, 8, 8);

        $ano2 = substr($fim, 0, 4);
        $mes2 = substr($fim, 5, 2);
        $dia2 = substr($fim, 8, 8);

        $inicio = $dia1 . "/" . $mes1 . "/" . $ano1;
        $fim = $dia2 . "/" . $mes2 . "/" . $ano2;

        //$w = array(60, 60, 70, 50, 70, 30, 30);
        $w = array(60, 50, 70, 50, 70, 30, 30);
        $this->SetFont('helvetica', 'B', 12);
        $this->Cell(190, 6, 'Extracto dos Pagamentos do Plano de Pensões ', 1, 0, 'C', 0);
        $this->Ln(12);
        $this->SetFont('helvetica', '', 10);
        $this->writeHTML("Vimos por este meio apresentar à V/Excia.(s) " . '<b>' . " $nomeassociado " . '</b>' . " , o extracto dos pagamentos da conta da Usoko, 
		
		da qual é tem feito pagamentos para o plano de pensões, para os movimentos efectuados no período de " . $inicio . " à " . $fim . ".", TRUE, FALSE, FALSE, FALSE, 'J');
        $this->Ln(8);

        if (!$lista) {
            $this->Ln(2);
            $this->SetFillColor(199, 196, 186);
            $this->SetFont('helvetica', 'B', 10);
            $this->Cell(10, 6, '#', 1, 0, 'C', 1);
            $this->Cell($w[0], 6, 'Valor (Akz)', 1, 0, 'C', 1);
            $this->Cell($w[1], 6, 'Mês-Ano referente', 1, 0, 'C', 1);
            $this->Cell($w[2], 6, 'Data de Pagamento', 1, 0, 'C', 1);
            $this->Ln();

            $this->SetFont('helvetica', 'B', 16);
            $this->Cell(190, 6, "Sem dados para apresentar", 1, 0, 'C', 0);
        } else {
            $this->Ln(2);
            $this->SetFont('helvetica', 'B', 10);
            $this->SetFillColor(199, 196, 186);
            $this->Cell(10, 6, '#', 1, 0, 'C', 1);
            $this->Cell($w[0], 6, 'Valor (Akz)', 1, 0, 'C', 1);
            $this->Cell($w[1], 6, 'Mês-Ano referente', 1, 0, 'C', 1);
            $this->Cell($w[2], 6, 'Data de Pagamento', 1, 0, 'C', 1);
            $this->Ln();

            $this->SetFont('helvetica', '', 10);


            $conta = 0;
            $cumulo = 0;
            foreach ($lista as $vector) {
                $conta++;
                if ($conta % 2 == 0) {
                    $this->SetFillColor(248, 248, 248);
                } else {
                    $this->SetFillColor(255, 255, 255);
                }
                $cumulo = $cumulo + $vector->getValor();
                $this->Cell(10, 6, $conta, 1, 0, 'C', 1);
                $this->Cell($w[0], 6, number_format($vector->getValor(), 2, ',', '.'), 1, 0, 'L', 1);
                $this->Cell($w[1], 6, $vector->getMesAno(), 1, 0, 'C', 1);
                $this->Cell($w[2], 6, $vector->getDataActual()->format('d/m/Y'), 1, 0, 'C', 1);
                $this->Ln();
            }
            $this->SetFont('helvetica', 'B', 10);
            $this->Cell(190, 6, 'Valor acumulado: ' . number_format($cumulo, 2, ',', '.') . " Akz ", 1, 0, 'R', 0);
        }
    }

    public function corpoRelatorioInfraccao($lista) {
        $this->SetY(55);
        $this->Ln(15);
        $this->Ln(5);

        $this->SetFont('times', 9);
        $w = array(10, 80, 70, 30, 50, 70, 30, 30);

        $this->SetFont('helvetica', 'B', 12);
        $this->Cell(190, 6, 'Relatório dos Associados Infraccionados ', 1, 0, 'C', 0);
        //$this->Ln(7);
        //$this->Cell(190, 6, 'Período de: '.$data1." à ".$data2, 1, 0, 'L', 0);
        $this->Ln(12);
        $this->SetFont('helvetica', '', 10);

        $this->Ln(8);

        if (!$lista) {
            $this->Ln(2);
            $this->SetFillColor(199, 196, 186);
            $this->SetFont('helvetica', 'B', 10);
            $this->Cell($w[0], 6, '#', 1, 0, 'C', 1);
            $this->Cell($w[1], 6, 'Nome Completo', 1, 0, 'C', 1);
            $this->Cell($w[2], 6, 'Infracção', 1, 0, 'C', 1);
            $this->Cell($w[3], 6, 'Quantidade', 1, 0, 'C', 1);
            $this->Ln();

            $this->SetFont('helvetica', 'B', 16);
            $this->Cell(190, 6, "Sem dados para apresentar", 1, 0, 'C', 0);
        } else {

            $this->Ln(2);
            $this->SetFont('helvetica', 'B', 10);
            $this->SetFillColor(199, 196, 186);
            $this->Cell($w[0], 6, '#', 1, 0, 'C', 1);
            $this->Cell($w[1], 6, 'Nome Completo', 1, 0, 'C', 1);
            $this->Cell($w[2], 6, 'Infracção', 1, 0, 'C', 1);
            $this->Cell($w[3], 6, 'Quantidade', 1, 0, 'C', 1);
            $this->Ln();

            $this->SetFont('helvetica', '', 10);

            $contP = 0;
            foreach ($lista as $vector) {
                $contP++;
                if ($contP % 2 == 0) {
                    $this->SetFillColor(248, 248, 248);
                } else {
                    $this->SetFillColor(255, 255, 255);
                }
                $this->Cell($w[0], 6, $contP, 1, 0, 'C', 1);
                $this->Cell($w[1], 6, $vector['nome'], 1, 0, 'L', 1);
                $this->Cell($w[2], 6, $vector['infra'], 1, 0, 'L', 1);
                $this->Cell($w[3], 6, $vector['qtd'], 1, 0, 'C', 1);
                $this->Ln();
            }
        }
    }

    public function corpoRelatorioAssociadoFicha($entity) {

        //Conteudo Superior
        //$pdf->cell(Define Largura,Define Altura,"This is cell",Define bordas,(1-quebra linha Default, 0 maantem na linha ),'C' - centrar os dado,1-Ativar Cor);
        $this->SetY(55);
        $this->Ln(0);

        //190 equivale a lagura de toda a pagina
        //Parte Superior
        //Parte Superior 1
        $this->SetFont('helvetica', '', 12);
        $this->Cell(120, 6, 'Ficha Do Associado', 0, 0, 'L', 0);
        $this->Cell(70, 6, 'N°01 ', 0, 1, 'R', 0);
        $this->Cell(190, 0, '_________________________________________________________________________________', 0, 1, 'C', 0);
        $this->Ln(1);

        //Parte Superior 2
        //$this->Cell(25, 35, '', 1, 0, 'C', 0);
        //Dados Pessoais Cada linha tera 5 de altura
        //$this->Cell(153, 35, '', 1, 1, 'C', 0);
        $this->SetFont('helvetica', 'B', 12);
        $this->SetFillColor(199, 196, 186);
        $this->Cell(25, 30, 'FOTO', 1, 0, 'C', 0);
        $this->Cell(2, 6, '', 0, 0, 'C', 0);
        $this->Cell(163, 6, 'Dados Pessoais', 1, 1, 'C', 1);

        $this->SetFont('helvetica', 'B', 10);
        $this->Cell(25, 6, '', 0, 0, 'C', 0);
        $this->Cell(2, 6, '', 0, 0, 'C', 0);
        $this->Cell(53, 6, 'Nome Completo', 1, 0, 'C', 0);
        $this->Cell(110, 6, $entity->getPessoa()->getNome(), 1, 1, 'C', 0);
        //$entity->getPessoa()->getNome()

        $this->Cell(25, 6, '', 0, 0, 'C', 0);
        $this->Cell(2, 6, '', 0, 0, 'C', 0);
        $this->Cell(53, 6, 'Gênero', 1, 0, 'C', 0);
        $genero = $entity->getPessoa()->getGenero();
        $this->Cell(110, 6, $genero == 'M' ? 'Masculino' :
                        $genero == 'F' ? 'Feminino' :
                                'Indefinido', 1, 1, 'C', 0);

        $this->Cell(25, 6, '', 0, 0, 'C', 0);
        $this->Cell(2, 6, '', 0, 0, 'C', 0);
        $this->Cell(53, 6, 'Estado Civil', 1, 0, 'C', 0);
        $estadoCivil = $entity->getPessoa()->getEstadoCivil();
        $this->Cell(110, 6, $estadoCivil == 'S' ? 'Solteiro(a)' :
                        $estadoCivil == 'C' ? 'Casado(a)' :
                                $estadoCivil == 'V' ? 'Viuvo(a)' :
                                        $estadoCivil == 'D' ? 'Divorciado(a)' :
                                                'Indefinido', 1, 1, 'C', 0);

        $this->Cell(25, 6, '', 0, 0, 'C', 0);
        $this->Cell(2, 6, '', 0, 0, 'C', 0);
        $this->Cell(53, 6, 'Data De Nascimento', 1, 0, 'C', 0);
        $dataNascimento = $estadoCivil = $entity->getPessoa()->getDataNascimento();
        $this->Cell(110, 6, date_format($dataNascimento, 'd/m/Y'), 1, 1, 'C', 0);



        $this->Ln(4);
        //Parte Superior 3
        //$this->Cell(190, 35, '', 1, 1, 'C', 0);
        //Line1
        $this->SetFont('helvetica', 'B', 12);
        $this->Cell(190, 7, 'Documento De Identificação', 1, 1, 'C', 1);

        //Line2
        $this->SetFont('helvetica', 'B', 10);
        $this->Cell(38, 7, 'Tipo De Documento', 1, 0, 'C', 0);
        // $this->Cell(140, 7, '', 1, 1, 'C', 0);
        //Line3
        $this->Cell(38, 7, 'Número', 1, 0, 'C', 0);
        // $this->Cell(140, 7, '', 1, 1, 'C', 0);
        //Line3
        $this->Cell(38, 7, 'Data De Emissão', 1, 0, 'C', 0);
        //$this->Cell(140, 7, '', 1, 1, 'C', 0);
        //Line4
        $this->Cell(38, 7, 'Data De Expiração', 1, 0, 'C', 0);
        //$this->Cell(140, 7, '', 1, 1, 'C', 0);
        //Line5
        $this->Cell(38, 7, 'Local De Emissão', 1, 1, 'C', 0);
        //$this->Cell(140, 7, '', 1, 1, 'C', 0);
        //Date
        //Line2
        $documentoidentificacao = $entity->getPessoa()->getDocumentoidentificacao();
        foreach ($documentoidentificacao as $docs):
            $tipodocumento = $docs->getTipodocumento();
            $this->SetFont('helvetica', 'B', 10);
            $this->Cell(38, 7, $tipodocumento->getTipo(), 1, 0, 'C', 0);
            //Line3
            $this->Cell(38, 7, $docs->getNumero(), 1, 0, 'C', 0);
            //Line3
            $this->Cell(38, 7, date_format($docs->getDataEmissao(), 'd/m/Y'), 1, 0, 'C', 0);
            //Line4
            $this->Cell(38, 7, date_format($docs->getDataExpiracao(), 'd/m/Y'), 1, 0, 'C', 0);
            //Line5
            $this->Cell(38, 7, $docs->getLocalEmissao(), 1, 1, 'C', 0);
        endforeach;


        $this->Ln(4);
        //Parte Superior 4
        //Line1
        $this->SetFont('helvetica', 'B', 12);
        $this->Cell(190, 7, 'Dados Da Morada', 1, 1, 'C', 1);
        //Line2
        $enderecos = $entity->getPessoa()->getEndereco();
        foreach ($enderecos as $endereco):
            $provincia = $endereco->getProvincia();
            $this->SetFont('helvetica', 'B', 10);
            $this->Cell(50, 7, 'Província', 1, 0, 'C', 0);
            $this->Cell(140, 7, $provincia->getNome(), 1, 1, 'C', 0);
            //Line3
            $municipio = $endereco->getMunicipio();
            $this->Cell(50, 7, 'Município', 1, 0, 'C', 0);
            $this->Cell(140, 7, $municipio->getNome(), 1, 1, 'C', 0);
            //Line4
            $this->Cell(50, 7, 'Bairro', 1, 0, 'C', 0);
            $this->Cell(140, 7, $endereco->getBairro()== 'null' ? 'Indefinido' : $endereco->getBairro(), 1, 1, 'C', 0);
            //Line5
            $this->Cell(50, 7, 'Rua', 1, 0, 'C', 0);
            $this->Cell(140, 7, $endereco->getRua()== 'null' ? 'Indefinido' : $endereco->getRua(), 1, 1, 'C', 0);
            //Line5
            $this->Cell(50, 7, 'Número', 1, 0, 'C', 0);
            $this->Cell(140, 7, $endereco->getNumero()== 'null' ? 'Indefinido' : $endereco->getNumero(), 1, 1, 'C', 0);
        endforeach;

        $this->Ln(4);
        //Parte Superior 5
        //Line1
        $this->SetFont('helvetica', 'B', 12);
        $this->Cell(190, 7, 'Dados do Funcionário', 1, 1, 'C', 1);
        //Line2
        $this->SetFont('helvetica', 'B', 10);
        $this->Cell(50, 7, 'N° Mecanógráfico', 1, 0, 'C', 0);
        $this->Cell(140, 7, $entity->getNMecanografico() == 'null' ? 'Indefinido' : $entity->getNMecanografico(), 1, 1, 'C', 0);
        $orgao = $entity->getOrgao();
        //Line3
        $this->Cell(50, 7, 'Orgão', 1, 0, 'C', 0);
        $this->Cell(140, 7, $orgao->getNome() == 'null' ? 'Indefinido' : $orgao->getNome(), 1, 1, 'C', 0);
        $cargo = $entity->getCargo();
        //Line4
        $this->Cell(50, 7, 'Cargo', 1, 0, 'C', 0);
        $this->Cell(140, 7, $cargo->getCargo() == 'null' ? 'Indefinido' : $cargo->getCargo(), 1, 1, 'C', 0);
        //Line5
        $profissao = $entity->getProfissao();
        $this->Cell(50, 7, 'Profissão', 1, 0, 'C', 0);
        $this->Cell(140, 7, $profissao->getNome() == 'null' ? 'Indefinido' : $profissao->getNome(), 1, 1, 'C', 0);
        //Line5
        //A - Activo, I - Inactivo, D - Desvinculado, R - Reformado, F - Falecido
        $tatus = $entity->getStatus();
        $this->Cell(50, 7, 'Status', 1, 0, 'C', 0);
        $this->Cell(140, 7, $tatus == 'A' ? 'Activo(a)' :
                        $tatus == 'I' ? 'Inactivo(a)' :
                                $tatus == 'D' ? 'Desvinculado(a)' :
                                        R == 'D' ? 'Reformado(a)' :
                                                R == 'D' ? 'Falecido(a)' :
                                                        'Indefinido'
                , 1, 1, 'C', 0);

        //End Conteudo Superior
        //Parte Inferior
        $this->SetFont('helvetica', '', 10);
        $this->Ln(20);
        $this->Cell(190, 5, '_____________________________________________', 0, 1, 'C', 0);
        $this->Cell(190, 5, 'Assinatura do(a) associado(a)', 0, 1, 'C', 0);


        $this->SetFont('helvetica', '', 10);

        $contP = 0;
        $soma = 0;
        /*       foreach ($lista as $vector) {
          $contP++;
          $soma = $soma + $vector['solic'];
          if ($contP % 2 == 0) {
          $this->SetFillColor(248, 248, 248);
          } else {
          $this->SetFillColor(255, 255, 255);
          }
          $this->Cell($w[0], 6, $contP, 1, 0, 'C', 1);
          $this->Cell($w[3], 6, $vector['nMec'], 1, 0, 'L', 1);
          $this->Cell($w[2], 6, $vector['nomes'], 1, 0, 'L', 1);
          $this->Cell($w[8], 6, $vector['nome'], 1, 0, 'L', 1);
          $this->Cell($w[9], 6, $vector['actual']->format("d/m/Y"), 1, 0, 'C', 1);
          $this->Cell($w[7], 6, number_format($vector['solic'], 2, ',', '.'), 1, 0, 'L', 1);
          $this->Ln();
          }
         */
    }

    public function corpoRelatorioAssociadoFicha2($id) {

        //Conteudo Superior
        //$pdf->cell(Define Largura,Define Altura,"This is cell",Define bordas,(1-quebra linha Default, 0 maantem na linha ),'C' - centrar os dado,1-Ativar Cor);
        $this->SetY(55);
        $this->Ln(0);

        //190 equivale a lagura de toda a pagina
        //Parte Superior
        //Parte Superior 1
        $this->SetFont('helvetica', '', 12);
        $this->Cell(120, 6, 'Ficha Do Associado', 0, 0, 'L', 0);
        $this->Cell(70, 6, 'N°01 ', 0, 1, 'R', 0);
        $this->Cell(190, 0, '_________________________________________________________________________________', 0, 1, 'C', 0);
        $this->Ln(1);

        //Parte Superior 2
        //$this->Cell(25, 35, '', 1, 0, 'C', 0);
        //Dados Pessoais Cada linha tera 5 de altura
        //$this->Cell(153, 35, '', 1, 1, 'C', 0);
        $this->SetFont('helvetica', 'B', 12);
        $this->SetFillColor(199, 196, 186);
        $this->Cell(25, 30, 'FOTO', 1, 0, 'C', 0);
        $this->Cell(2, 6, '', 0, 0, 'C', 0);
        $this->Cell(163, 6, 'Dados Pessoais', 1, 1, 'C', 1);

        $this->SetFont('helvetica', 'B', 10);
        $this->Cell(25, 6, '', 0, 0, 'C', 0);
        $this->Cell(2, 6, '', 0, 0, 'C', 0);
        $this->Cell(53, 6, 'Nome Completo', 1, 0, 'C', 0);
        $this->Cell(110, 6, '', 1, 1, 'C', 0);

        $this->Cell(25, 6, '', 0, 0, 'C', 0);
        $this->Cell(2, 6, '', 0, 0, 'C', 0);
        $this->Cell(53, 6, 'Gênero', 1, 0, 'C', 0);
        $this->Cell(110, 6, '', 1, 1, 'C', 0);

        $this->Cell(25, 6, '', 0, 0, 'C', 0);
        $this->Cell(2, 6, '', 0, 0, 'C', 0);
        $this->Cell(53, 6, 'Estado Civil', 1, 0, 'C', 0);
        $this->Cell(110, 6, '', 1, 1, 'C', 0);

        $this->Cell(25, 6, '', 0, 0, 'C', 0);
        $this->Cell(2, 6, '', 0, 0, 'C', 0);
        $this->Cell(53, 6, 'Data De Nascimento', 1, 0, 'C', 0);
        $this->Cell(110, 6, '', 1, 1, 'C', 0);



        $this->Ln(4);
        //Parte Superior 3
        //$this->Cell(190, 35, '', 1, 1, 'C', 0);
        //Line1
        $this->SetFont('helvetica', 'B', 12);
        $this->Cell(190, 7, 'Documento De Identificação', 1, 1, 'C', 1);
        //Line2
        $this->SetFont('helvetica', 'B', 10);
        $this->Cell(50, 7, 'Tipo De Documento', 1, 0, 'C', 0);
        $this->Cell(140, 7, '', 1, 1, 'C', 0);
        //Line3
        $this->Cell(50, 7, 'Número', 1, 0, 'C', 0);
        $this->Cell(140, 7, '', 1, 1, 'C', 0);
        //Line3
        $this->Cell(50, 7, 'Data De Emissão', 1, 0, 'C', 0);
        $this->Cell(140, 7, '', 1, 1, 'C', 0);
        //Line4
        $this->Cell(50, 7, 'Data De Expiração', 1, 0, 'C', 0);
        $this->Cell(140, 7, '', 1, 1, 'C', 0);
        //Line5
        $this->Cell(50, 7, 'Local De Emissão', 1, 0, 'C', 0);
        $this->Cell(140, 7, '', 1, 1, 'C', 0);

        $this->Ln(4);
        //Parte Superior 4
        //Line1
        $this->SetFont('helvetica', 'B', 12);
        $this->Cell(190, 7, 'Dados Da Morada', 1, 1, 'C', 1);
        //Line2
        $this->SetFont('helvetica', 'B', 10);
        $this->Cell(50, 7, 'Província', 1, 0, 'C', 0);
        $this->Cell(140, 7, '', 1, 1, 'C', 0);
        //Line3
        $this->Cell(50, 7, 'Município', 1, 0, 'C', 0);
        $this->Cell(140, 7, '', 1, 1, 'C', 0);
        //Line4
        $this->Cell(50, 7, 'Bairro', 1, 0, 'C', 0);
        $this->Cell(140, 7, '', 1, 1, 'C', 0);
        //Line5
        $this->Cell(50, 7, 'Rua', 1, 0, 'C', 0);
        $this->Cell(140, 7, '', 1, 1, 'C', 0);
        //Line5
        $this->Cell(50, 7, 'Número', 1, 0, 'C', 0);
        $this->Cell(140, 7, '', 1, 1, 'C', 0);

        $this->Ln(4);
        //Parte Superior 5
        //Line1
        $this->SetFont('helvetica', 'B', 12);
        $this->Cell(190, 7, 'Dados do Funcionário', 1, 1, 'C', 1);
        //Line2
        $this->SetFont('helvetica', 'B', 10);
        $this->Cell(50, 7, 'N° Mecanógráfico', 1, 0, 'C', 0);
        $this->Cell(140, 7, '', 1, 1, 'C', 0);
        //Line3
        $this->Cell(50, 7, 'Orgão', 1, 0, 'C', 0);
        $this->Cell(140, 7, '', 1, 1, 'C', 0);
        //Line4
        $this->Cell(50, 7, 'Cargo', 1, 0, 'C', 0);
        $this->Cell(140, 7, '', 1, 1, 'C', 0);
        //Line5
        $this->Cell(50, 7, 'Profissão', 1, 0, 'C', 0);
        $this->Cell(140, 7, '', 1, 1, 'C', 0);
        //Line5
        $this->Cell(50, 7, 'Status', 1, 0, 'C', 0);
        $this->Cell(140, 7, '', 1, 1, 'C', 0);

        //End Conteudo Superior
        //Parte Inferior
        $this->SetFont('helvetica', '', 10);
        $this->Ln(20);
        $this->Cell(190, 5, '_____________________________________________', 0, 1, 'C', 0);
        $this->Cell(190, 5, 'Assinatura do(a) associado(a)', 0, 1, 'C', 0);


        $this->SetFont('helvetica', '', 10);

        $contP = 0;
        $soma = 0;
        /*       foreach ($lista as $vector) {
          $contP++;
          $soma = $soma + $vector['solic'];
          if ($contP % 2 == 0) {
          $this->SetFillColor(248, 248, 248);
          } else {
          $this->SetFillColor(255, 255, 255);
          }
          $this->Cell($w[0], 6, $contP, 1, 0, 'C', 1);
          $this->Cell($w[3], 6, $vector['nMec'], 1, 0, 'L', 1);
          $this->Cell($w[2], 6, $vector['nomes'], 1, 0, 'L', 1);
          $this->Cell($w[8], 6, $vector['nome'], 1, 0, 'L', 1);
          $this->Cell($w[9], 6, $vector['actual']->format("d/m/Y"), 1, 0, 'C', 1);
          $this->Cell($w[7], 6, number_format($vector['solic'], 2, ',', '.'), 1, 0, 'L', 1);
          $this->Ln();
          }
         */
    }

    public function corpoRelatorioAssociadoFichaAntes($id) {
        $this->SetY(55);
        $this->Ln(15);
        $this->Ln(5);

        $this->SetFont('times', 9);
        $w = array(10, 80, 70, 25, 45, 70, 30, 35, 25, 27);

        $this->SetFont('helvetica', 'B', 12);
        $this->Cell(190, 6, 'Ficha de Associados ', 1, 0, 'C', 0);
        //$this->Ln(7);
        //$this->Cell(190, 6, 'Período de: '.$data1." à ".$data2, 1, 0, 'L', 0);
        $this->Ln(12);
        $this->SetFont('helvetica', '', 10);

        $this->Ln(8);

        $this->Ln(2);
        $this->SetFont('helvetica', 'B', 10);
        $this->SetFillColor(199, 196, 186);
        $this->Cell($w[0], 6, '#', 1, 0, 'C', 1);
        $this->Cell($w[3], 6, 'Nº. Mecan.', 1, 0, 'C', 1);
        $this->Cell($w[2], 6, 'Nome Completo', 1, 0, 'C', 1);
        $this->Cell($w[8], 6, 'Tipo', 1, 0, 'C', 1);
        $this->Cell($w[9], 6, 'Data do Pedido', 1, 0, 'C', 1);
        $this->Cell($w[7], 6, 'Valor Solicitado(Kz)', 1, 0, 'L', 1);
        $this->Ln();

        $this->SetFont('helvetica', '', 10);

        $contP = 0;
        $soma = 0;
        /*       foreach ($lista as $vector) {
          $contP++;
          $soma = $soma + $vector['solic'];
          if ($contP % 2 == 0) {
          $this->SetFillColor(248, 248, 248);
          } else {
          $this->SetFillColor(255, 255, 255);
          }
          $this->Cell($w[0], 6, $contP, 1, 0, 'C', 1);
          $this->Cell($w[3], 6, $vector['nMec'], 1, 0, 'L', 1);
          $this->Cell($w[2], 6, $vector['nomes'], 1, 0, 'L', 1);
          $this->Cell($w[8], 6, $vector['nome'], 1, 0, 'L', 1);
          $this->Cell($w[9], 6, $vector['actual']->format("d/m/Y"), 1, 0, 'C', 1);
          $this->Cell($w[7], 6, number_format($vector['solic'], 2, ',', '.'), 1, 0, 'L', 1);
          $this->Ln();
          }
         */
        $this->SetFont('helvetica', 'B', 10);
        $this->Ln(2);
        $this->Cell(190, 6, 'Total: ' . number_format($soma, 2, ',', '.'), 1, 0, 'R', 0);
    }

//Aqui Edson
    public function corpoRelatorioAssociadoCredito($lista) {
        $this->SetY(55);
        $this->Ln(15);
        $this->Ln(5);

        $this->SetFont('times', 9);
        $w = array(10, 80, 70, 25, 45, 70, 30, 35, 25, 27);

        $this->SetFont('helvetica', 'B', 12);
        $this->Cell(190, 6, 'Relatório dos associados com créditos aprovados e não pagos ', 1, 0, 'C', 0);
        //$this->Ln(7);
        //$this->Cell(190, 6, 'Período de: '.$data1." à ".$data2, 1, 0, 'L', 0);
        $this->Ln(12);
        $this->SetFont('helvetica', '', 10);

        $this->Ln(8);

        $this->Ln(2);
        $this->SetFont('helvetica', 'B', 10);
        $this->SetFillColor(199, 196, 186);
        $this->Cell($w[0], 6, '#', 1, 0, 'C', 1);
        $this->Cell($w[3], 6, 'Nº. Mecan.', 1, 0, 'C', 1);
        $this->Cell($w[2], 6, 'Nome Completo', 1, 0, 'C', 1);
        $this->Cell($w[8], 6, 'Tipo', 1, 0, 'C', 1);
        $this->Cell($w[9], 6, 'Data do Pedido', 1, 0, 'C', 1);
        $this->Cell($w[7], 6, 'Valor Solicitado(Kz)', 1, 0, 'L', 1);
        $this->Ln();

        $this->SetFont('helvetica', '', 10);

        $contP = 0;
        $soma = 0;
        foreach ($lista as $vector) {
            $contP++;
            $soma = $soma + $vector['solic'];
            if ($contP % 2 == 0) {
                $this->SetFillColor(248, 248, 248);
            } else {
                $this->SetFillColor(255, 255, 255);
            }
            $this->Cell($w[0], 6, $contP, 1, 0, 'C', 1);
            $this->Cell($w[3], 6, $vector['nMec'], 1, 0, 'L', 1);
            $this->Cell($w[2], 6, $vector['nomes'], 1, 0, 'L', 1);
            $this->Cell($w[8], 6, $vector['nome'], 1, 0, 'L', 1);
            $this->Cell($w[9], 6, $vector['actual']->format("d/m/Y"), 1, 0, 'C', 1);
            $this->Cell($w[7], 6, number_format($vector['solic'], 2, ',', '.'), 1, 0, 'L', 1);
            $this->Ln();
        }
        $this->SetFont('helvetica', 'B', 10);
        $this->Ln(2);
        $this->Cell(190, 6, 'Total: ' . number_format($soma, 2, ',', '.'), 1, 0, 'R', 0);
    }

    public function corpoRelatorioAssociadoRecusadosCredito($lista) {
        $this->SetY(55);
        $this->Ln(15);
        $this->Ln(5);

        $this->SetFont('times', 9);
        $w = array(10, 80, 70, 30, 45, 45, 30, 35);

        $this->SetFont('helvetica', 'B', 12);
        $this->Cell(190, 6, 'Relatório dos associados com crédito(s) recusado(s) ', 1, 0, 'C', 0);
        //$this->Ln(7);
        //$this->Cell(190, 6, 'Período de: '.$data1." à ".$data2, 1, 0, 'L', 0);
        $this->Ln(12);
        $this->SetFont('helvetica', '', 10);

        $this->Ln(8);

        $this->Ln(2);
        $this->SetFont('helvetica', 'B', 10);
        $this->SetFillColor(199, 196, 186);
        $this->Cell($w[0], 6, '#', 1, 0, 'C', 1);
        $this->Cell($w[7], 6, 'Nº. Mecanográfico', 1, 0, 'C', 1);
        $this->Cell($w[2], 6, 'Nome Completo', 1, 0, 'C', 1);
        $this->Cell($w[3], 6, 'Tipo', 1, 0, 'C', 1);
        $this->Cell($w[4], 6, 'Valor solicitado (Akz) ', 1, 0, 'C', 1);
        $this->Ln();

        $this->SetFont('helvetica', '', 10);

        $contP = 0;
        $soma = 0;
        foreach ($lista as $vector) {
            $contP++;
            $soma = $soma + $vector['valores'];
            if ($contP % 2 == 0) {
                $this->SetFillColor(248, 248, 248);
            } else {
                $this->SetFillColor(255, 255, 255);
            }
            $this->Cell($w[0], 6, $contP, 1, 0, 'C', 1);
            $this->Cell($w[7], 6, $vector['nMec'], 1, 0, 'L', 1);
            $this->Cell($w[2], 6, $vector['nome'], 1, 0, 'L', 1);
            $this->Cell($w[3], 6, $vector['ccc'], 1, 0, 'L', 1);
            $this->Cell($w[4], 6, number_format($vector['valores'], 2, ',', '.'), 1, 0, 'C', 1);
            $this->Ln();
        }
        $this->SetFont('helvetica', 'B', 10);
        $this->Ln(2);
        $this->Cell(190, 6, 'Total: ' . number_format($soma, 2, ',', '.'), 1, 0, 'R', 0);
    }

    public function corpoRelatorioAssociadosNoPP($lista) {
        $this->SetY(55);
        $this->Ln(15);
        $this->Ln(5);

        $this->SetFont('times', 9);
        $w = array(10, 80, 70, 30, 45, 45, 30, 35);

        $this->SetFont('helvetica', 'B', 12);
        $this->Cell(190, 6, 'Relatório dos associados no plano de pensões  ', 1, 0, 'C', 0);
        $this->Ln(12);
        $this->SetFont('helvetica', '', 10);

        $this->Ln(8);

        $this->Ln(2);
        $this->SetFont('helvetica', 'B', 10);
        $this->SetFillColor(199, 196, 186);
        $this->Cell($w[0], 6, '#', 1, 0, 'C', 1);
        $this->Cell($w[7], 6, 'Nº. Mecanográfico', 1, 0, 'C', 1);
        $this->Cell($w[2], 6, 'Nome Completo', 1, 0, 'C', 1);
        $this->Cell($w[3], 6, 'Data de Adesão', 1, 0, 'C', 1);
        $this->Cell($w[4], 6, 'Valor(Akz)', 1, 0, 'L', 1);
        $this->Ln();

        $this->SetFont('helvetica', '', 10);

        $contP = 0;
        foreach ($lista as $vector) {
            $contP++;
            if ($contP % 2 == 0) {
                $this->SetFillColor(248, 248, 248);
            } else {
                $this->SetFillColor(255, 255, 255);
            }
            $this->Cell($w[0], 6, $contP, 1, 0, 'C', 1);
            $this->Cell($w[7], 6, $vector['nMec'], 1, 0, 'L', 1);
            $this->Cell($w[2], 6, $vector['nomes'], 1, 0, 'L', 1);
            $this->Cell($w[3], 6, $vector['dada']->format('d/m/Y'), 1, 0, 'C', 1);
            $this->Cell($w[4], 6, number_format($vector['valores'], 2, ',', '.'), 1, 0, 'L', 1);
            $this->Ln();
        }
    }

    public function corpoRelatorioAssociadosDesvinculadosPP($lista) {
        $this->SetY(55);
        $this->Ln(15);
        $this->Ln(5);

        $this->SetFont('times', 9);
        $w = array(10, 80, 70, 30, 45, 45, 30, 35);

        $this->SetFont('helvetica', 'B', 12);
        $this->Cell(190, 6, 'Relatório dos associados desvinculados no plano de pensões  ', 1, 0, 'C', 0);
        $this->Ln(12);
        $this->SetFont('helvetica', '', 10);

        $this->Ln(8);

        $this->Ln(2);
        $this->SetFont('helvetica', 'B', 10);
        $this->SetFillColor(199, 196, 186);
        $this->Cell($w[0], 6, '#', 1, 0, 'C', 1);
        $this->Cell($w[7], 6, 'Nº. Mecanográfico', 1, 0, 'C', 1);
        $this->Cell($w[2], 6, 'Nome Completo', 1, 0, 'C', 1);
        $this->Cell($w[3], 6, 'Data de Desv.', 1, 0, 'C', 1);
        $this->Cell($w[4], 6, 'Valor Acumulado(Akz)', 1, 0, 'L', 1);
        $this->Ln();

        $this->SetFont('helvetica', '', 10);

        $contP = 0;
        foreach ($lista as $vector) {
            $contP++;
            if ($contP % 2 == 0) {
                $this->SetFillColor(248, 248, 248);
            } else {
                $this->SetFillColor(255, 255, 255);
            }
            $this->Cell($w[0], 6, $contP, 1, 0, 'C', 1);
            $this->Cell($w[7], 6, $vector['nMec'], 1, 0, 'L', 1);
            $this->Cell($w[2], 6, $vector['nomeDele'], 1, 0, 'L', 1);
            $this->Cell($w[3], 6, $vector['actual']->format('d/m/Y'), 1, 0, 'C', 1);
            $this->Cell($w[4], 6, number_format($vector['val'], 2, ',', '.'), 1, 0, 'L', 1);
            $this->Ln();
        }
    }

    public function corpoRelatorioAssociadoTipoCredito($lista) {
        $this->SetY(55);
        $this->Ln(15);
        $this->Ln(5);

        $this->SetFont('times', 9);
        $w = array(10, 80, 70, 30, 45, 70, 30, 35, 50, 60);

        $this->SetFont('helvetica', 'B', 12);
        $this->Cell(190, 6, 'Relatório dos tipos de créditos solicitados e não pagos ', 1, 0, 'C', 0);
        $this->Ln(12);
        $this->SetFont('helvetica', '', 10);

        $this->Ln(8);

        $this->Ln(2);
        $this->SetFont('helvetica', 'B', 10);
        $this->SetFillColor(199, 196, 186);
        $this->Cell($w[0], 6, '#', 1, 0, 'C', 1);
        $this->Cell($w[2], 6, 'Tipo de Crédito', 1, 0, 'L', 1);
        $this->Cell($w[9], 6, 'Quantidade de associados', 1, 0, 'L', 1);
        $this->Cell($w[8], 6, 'Valor Acumulado(Akz)', 1, 0, 'L', 1);
        //$this->Cell($w[3], 6, 'Data de Adesão', 1, 0, 'C', 1);
        $this->Ln();

        $this->SetFont('helvetica', '', 10);

        $contP = 0;
        foreach ($lista as $vector) {
            $contP++;
            if ($contP % 2 == 0) {
                $this->SetFillColor(248, 248, 248);
            } else {
                $this->SetFillColor(255, 255, 255);
            }
            $this->Cell($w[0], 6, $contP, 1, 0, 'C', 1);
            $this->Cell($w[2], 6, $vector['nom'], 1, 0, 'L', 1);
            $this->Cell($w[9], 6, $vector['qtd'], 1, 0, 'L', 1);
            $this->Cell($w[8], 6, number_format($vector['total'], 2, ',', '.'), 1, 0, 'L', 1);
            //$this->Cell($w[4], 6,$vector['nome'], 1, 0, 'L', 1);
            //$this->Cell($w[3], 6,$vector['actual']->format("d/m/Y"), 1, 0, 'C', 1);
            $this->Ln();
        }
    }

    public function corpoRelatorioPagamento($lista, $data1, $data2) {
        $this->SetY(55);
        $this->Ln(15);
        $this->Ln(5);

        $this->SetFont('times', 9);

        $ano1 = substr($data1, 0, 4);
        $mes1 = substr($data1, 5, 2);
        $dia1 = substr($data1, 8, 8);

        $ano2 = substr($data2, 0, 4);
        $mes2 = substr($data2, 5, 2);
        $dia2 = substr($data2, 8, 8);

        $data1 = $dia1 . "/" . $mes1 . "/" . $ano1;
        $data2 = $dia2 . "/" . $mes2 . "/" . $ano2;

        $w = array(10, 35, 75, 45, 50, 70, 30, 30);
        $soma = 0;
        $this->SetFont('helvetica', 'B', 12);
        $this->Cell(190, 6, 'Relatório dos Pagamentos dos Associados ', 1, 0, 'C', 0);
        $this->Ln(7);
        $this->Cell(190, 6, 'Período de: ' . $data1 . " à " . $data2, 1, 0, 'L', 0);
        $this->Ln(12);
        $this->SetFont('helvetica', '', 10);

        $this->Ln(8);

        $this->Ln(2);
        $this->SetFont('helvetica', 'B', 10);

        $this->SetFillColor(199, 196, 186);
        $this->Cell($w[0], 6, '#', 1, 0, 'C', 1);
        $this->Cell($w[1], 6, 'Nº. Mecanográfico', 1, 0, 'C', 1);
        $this->Cell($w[2], 6, 'Nome Completo', 1, 0, 'C', 1);
        $this->Cell($w[1], 6, 'Contribuição', 1, 0, 'C', 1);
        $this->Cell($w[1], 6, 'Valor Pago(Akz)', 1, 0, 'C', 1);
        $this->Ln();

        $this->SetFont('helvetica', '', 10);

        $contP = 0;
        foreach ($lista as $vector) {
            $contP++;
            $soma = $soma + $vector['total'];
            if ($contP % 2 == 0) {
                $this->SetFillColor(248, 248, 248);
            } else {
                $this->SetFillColor(255, 255, 255);
            }
            $this->Cell($w[0], 6, $contP, 1, 0, 'C', 1);
            $this->Cell($w[1], 6, $vector['meca'], 1, 0, 'L', 1);
            $this->Cell($w[2], 6, $vector['nome'], 1, 0, 'L', 1);
            $this->Cell($w[1], 6, $vector['tipos'], 1, 0, 'L', 1);
            $this->Cell($w[1], 6, number_format($vector['total'], 2, ',', '.'), 1, 0, 'L', 1);
            $this->Ln();
        }

        $this->SetFont('helvetica', 'B', 10);
        $this->Ln(2);
        $this->Cell(190, 6, 'Total: ' . number_format($soma, 2, ',', '.'), 1, 0, 'R', 0);
    }

    public function corpoRelatorioComparticipacao($lista, $data1, $data2) {

        $this->SetY(55);
        $this->Ln(15);
        $this->Ln(5);


        $ano1 = substr($data1, 0, 4);
        $mes1 = substr($data1, 5, 2);
        $dia1 = substr($data1, 8, 8);

        $ano2 = substr($data2, 0, 4);
        $mes2 = substr($data2, 5, 2);
        $dia2 = substr($data2, 8, 8);

        $data1 = $dia1 . "/" . $mes1 . "/" . $ano1;
        $data2 = $dia2 . "/" . $mes2 . "/" . $ano2;

        $this->SetFont('times', 9);
        $w = array(10, 20, 60, 70, 50, 70, 30, 30);

        $this->SetFont('helvetica', 'B', 12);
        $this->Cell(190, 6, 'Relatório das Comparticipações dos Associados ', 1, 0, 'C', 0);
        $this->Ln(7);
        $this->Cell(190, 6, 'Período de: ' . $data1 . " à " . $data2, 1, 0, 'L', 0);
        $this->Ln(12);
        $this->SetFont('helvetica', '', 10);

        $this->Ln(8);
        $total = 0;
        $this->Ln(2);
        $this->SetFont('helvetica', 'B', 10);
        $this->SetFillColor(199, 196, 186);
        $this->Cell($w[0], 6, '#', 1, 0, 'C', 1);
        $this->Cell($w[1], 6, 'Nº. Mecan.', 1, 0, 'C', 1);
        $this->Cell($w[2], 6, 'Nome Completo', 1, 0, 'C', 1);
        $this->Cell($w[3], 6, 'Subsídio', 1, 0, 'C', 1);
        $this->Cell($w[7], 6, 'Valor Pago(Akz)', 1, 0, 'C', 1);
        $this->Ln();

        $this->SetFont('helvetica', '', 10);

        $contP = 0;
        foreach ($lista as $vector) {
            $contP++;
            $total = $total + $vector['total'];
            if ($contP % 2 == 0) {
                $this->SetFillColor(248, 248, 248);
            } else {
                $this->SetFillColor(255, 255, 255);
            }

            $this->Cell($w[0], 6, $contP, 1, 0, 'C', 1);
            $this->Cell($w[1], 6, $vector['nMecanografico'], 1, 0, 'L', 1);
            $this->Cell($w[2], 6, $vector['nome'], 1, 0, 'L', 1);
            $this->Cell($w[3], 6, $this->abreviaNomes($vector['subs'], 30), 1, 0, 'L', 1);
            $this->Cell($w[7], 6, number_format($vector['total'], 2, ',', '.'), 1, 0, 'L', 1);
            $this->Ln();
        }
        $this->SetFont('helvetica', 'B', 10);
        $this->Ln(2);
        $this->Cell(190, 6, 'Total : ' . number_format($total, 2, ',', '.'), 1, 0, 'R', 0);
    }

    public function corpoRelatorioSubsidio($lista, $data1, $data2) {
        $this->SetY(55);
        $this->Ln(15);
        $this->Ln(5);

        $total = 0;
        $ano1 = substr($data1, 0, 4);
        $mes1 = substr($data1, 5, 2);
        $dia1 = substr($data1, 8, 8);

        $ano2 = substr($data2, 0, 4);
        $mes2 = substr($data2, 5, 2);
        $dia2 = substr($data2, 8, 8);

        $data1 = $dia1 . "/" . $mes1 . "/" . $ano1;
        $data2 = $dia2 . "/" . $mes2 . "/" . $ano2;

        $this->SetFont('times', 9);
        $w = array(10, 20, 60, 70, 50, 90, 30, 30);

        $this->SetFont('helvetica', 'B', 12);
        $this->Cell(190, 6, 'Relatório dos subsídios ', 1, 0, 'C', 0);
        $this->Ln(7);
        $this->Cell(190, 6, 'Período de: ' . $data1 . " à " . $data2, 1, 0, 'L', 0);
        $this->Ln(12);
        $this->SetFont('helvetica', '', 10);

        $this->Ln(8);

        $this->Ln(2);
        $this->SetFont('helvetica', 'B', 10);

        $this->SetFillColor(199, 196, 186);
        $this->Cell(10, 6, '#', 1, 0, 'C', 1);
        $this->Cell(50, 6, 'Associado', 1, 0, 'C', 1);
        $this->Cell(30, 6, 'Tipo de Subsídio', 1, 0, 'C', 1);
        $this->Cell(40, 6, 'Valor(Akz)', 1, 0, 'C', 1);
        $this->Cell(30, 6, 'Código', 1, 0, 'C', 1);
        $this->Cell(30, 6, 'Estado', 1, 0, 'C', 1);
        $this->Ln();

        $this->SetFont('helvetica', '', 10);

        $contP = 0;
        foreach ($lista as $vector) {
            $contP++;
            $total = $total + $vector->getValor();
            if ($contP % 2 == 0) {
                $this->SetFillColor(248, 248, 248);
            } else {
                $this->SetFillColor(255, 255, 255);
            }
            $this->Cell(10, 6, $contP, 1, 0, 'C', 0);
            $this->Cell(50, 6, $this->abreviaNomes($vector->getAssociado()->getPessoa()->getNome()), 1, 0, 'L', 1);
            $this->Cell(30, 6, $this->abreviaNomes($vector->getSubsidio()->getCategoria()->getNome()), 1, 0, 'L', 1);
            $this->Cell(40, 6, number_format($vector->getValor(), 2, ',', '.'), 1, 0, 'L', 1);
            $this->Cell(30, 6, $vector->getCodigo(), 1, 0, 'L', 1);
            $estad = "";
            if ($vector->getEstado() == 'P') {
                $estad = "Pendente";
            } else if ($vector->getEstado() == 'A') {
                $estad = "Aprovado";
            } else if ($vector->getEstado() == 'R') {
                $estad = "Reprovado";
            }
            $this->Cell(30, 6, $estad, 1, 0, 'L', 1);

            $this->Ln();
        }
        $this->SetFont('helvetica', 'B', 10);
        $this->Ln(2);
        //$this->Cell(190, 6, 'Total : '.number_format($total,2,',','.')." (". $this->valorPorExtenso((double)number_format($total,2,',','.'),false, false).") ", 1, 0, 'R', 0);
        $this->Cell(190, 6, 'Total : ' . number_format($total, 2, ',', '.'), 1, 0, 'R', 0);
    }

    public function ordemTransfCredito($lista, $data1, $data2, $conta) {
        $this->SetY(55);
        $this->Ln(8);

        $this->SetFont('helvetica', 9);

        $ano1 = substr($data1, 0, 4);
        $mes1 = substr($data1, 5, 2);
        $dia1 = substr($data1, 8, 8);

        $ano2 = substr($data2, 0, 4);
        $mes2 = substr($data2, 5, 2);
        $dia2 = substr($data2, 8, 8);

        $data1 = $dia1 . "/" . $mes1 . "/" . $ano1;
        $data2 = $dia2 . "/" . $mes2 . "/" . $ano2;

        $w = array(10, 20, 60, 70, 50, 90, 30, 30);
        $totalpag = 0;
        foreach ($lista as $vector) {
            $totalpag = $totalpag + $vector['massa'];
        }

        $ttotal = (string) number_format($totalpag, 2, ',', '.');


        $this->writeHTML("AO" . "<BR/>");
        $this->writeHTML("BANCO DE POUPANÇA E CRÉDITO" . "<BR/>");
        $this->writeHTML("Luanda, " . $this->retornaDataPortugues(date('Y-m-d')));
        $this->Ln(12);
        $this->SetFont('helvetica', 'B', 12);
        $this->Cell(190, 6, 'ASSUNTO: TRANSFERÊNCIA DE VALORES ', 0, 0, 'L', 0);
        $this->Ln(12);

        if ($ttotal <= 0) {
            $this->SetFont('helvetica', 10);
            $this->writeHTML("Queiram transferir da nossa conta n.º $conta, domiciliada no  vosso banco o montante de" . "<br/>");
            $this->writeHTML(" Kz 0,00 " . " (0 Kwanzas) a título de crédito interno. " . "<br/>");
            $this->writeHTML("" . "<br/>");

            $this->SetFont('helvetica', '', 10);
            $this->Ln(4);
            $this->SetFont('helvetica', 'B', 10);


            $this->Ln(2);

            $this->SetFillColor(199, 196, 186);
            $this->Cell(10, 6, '#', 1, 0, 'C', 1);
            $this->Cell(20, 6, 'Conta Nº', 1, 0, 'C', 1);
            $this->Cell(80, 6, 'Nome', 1, 0, 'C', 1);
            $this->Cell(40, 6, 'Valor (Akz)', 1, 0, 'C', 1);
            $this->Cell(40, 6, 'Código', 1, 0, 'C', 1);
            $this->Ln();

            $this->SetFont('helvetica', 'B', 16);
            $this->Cell(190, 6, "Sem dados para apresentar", 1, 0, 'C', 0);
        } else {


            $this->SetFont('helvetica', 10);
            $this->writeHTML("Queiram transferir da nossa conta n.º $conta, domiciliada no  vosso banco o montante de" . "<br/>");
            $this->writeHTML(" Kz $ttotal" . " (" . $this->valorPorExtenso((double) $totalpag, false, false) . " Kwanzas) a título de crédito interno. " . "<br/>");
            $this->writeHTML("" . "<br/>");

            $this->SetFont('helvetica', '', 10);
            $this->Ln(4);
            $this->SetFont('helvetica', 'B', 10);


            $this->SetFillColor(199, 196, 186);
            $this->Cell(10, 6, '#', 1, 0, 'C', 1);
            $this->Cell(20, 6, 'Nº. Conta', 1, 0, 'C', 1);
            $this->Cell(60, 6, 'Nome', 1, 0, 'C', 1);
            $this->Cell(40, 6, 'Valor Aprovado', 1, 0, 'C', 1);
            $this->Cell(50, 6, 'Código', 1, 0, 'C', 1);
            $this->Ln();

            $this->SetFont('helvetica', '', 10);


            $stilo = array(
                'position' => '',
                'align' => 'C',
                'stretch' => false,
                'fitwidth' => true,
                'cellfitalign' => '',
                'border' => false, //true ->adiciona borda
                'hpadding' => 'auto',
                'vpadding' => 'auto',
                'fgcolor' => array(0, 0, 0),
                'bgcolor' => false, //array(255,255,255),
                'text' => false,
                'font' => 'helvetica',
                'fontsize' => 8,
                'stretchtext' => 4
            );

            $contP = 0;
            foreach ($lista as $vector) {
                $contP++;

                if ($contP % 2 == 0) {
                    $this->SetFillColor(248, 248, 248);
                } else {
                    $this->SetFillColor(255, 255, 255);
                }
                $this->Cell(10, 18, $contP, 1, 0, 'C', 0);
                $this->Cell(20, 18, $this->abreviaNomes($vector['Mec']), 1, 0, 'L', 1);
                $this->Cell(60, 18, $this->abreviaNomes($vector['NomeDele']), 1, 0, 'L', 1);
                $this->Cell(40, 18, number_format($vector['massa'], 2, ',', '.'), 1, 0, 'L', 1);
                $this->write1DBarcode($vector['codex'], 'C39', '', '', 50, 16, 0.4, $stilo, 'M');

                $this->Ln();
            }
        }
    }

    public function ordemTransfSubsidio($lista, $data1, $data2, $conta) {
        $this->SetY(55);
        $this->Ln(8);

        $this->SetFont('helvetica', 9);
        $w = array(10, 20, 60, 70, 50, 90, 30, 30);
        $totalpag = 0;
        foreach ($lista as $vector) {
            $totalpag = $totalpag + $vector['massa'];
        }

        $ttotal = (string) number_format($totalpag, 2, ',', '.');


        $this->writeHTML("AO" . "<BR/>");
        $this->writeHTML("BANCO DE POUPANÇA E CRÉDITO" . "<BR/>");
        $this->writeHTML("Luanda, " . $this->retornaDataPortugues(date('Y-m-d')));
        $this->Ln(12);
        $this->SetFont('helvetica', 'B', 12);
        $this->Cell(190, 6, 'ASSUNTO: TRANSFERÊNCIA DE VALORES ', 0, 0, 'L', 0);
        $this->Ln(12);

        if ($ttotal <= 0) {
            $this->SetFont('helvetica', 10);
            $this->writeHTML("Queiram transferir da nossa conta n.º $conta, domiciliada no  vosso banco o montante de" . "<br/>");
            $this->writeHTML(" Kz 0,00 " . " (0 Kwanzas) a título de subsídio. " . "<br/>");
            $this->writeHTML("" . "<br/>");

            $this->SetFont('helvetica', '', 10);
            $this->Ln(4);
            $this->SetFont('helvetica', 'B', 10);


            $this->Ln(2);

            $this->SetFillColor(199, 196, 186);
            $this->Cell(10, 6, '#', 1, 0, 'C', 1);
            $this->Cell(20, 6, 'Nº.Mec.', 1, 0, 'C', 1);
            $this->Cell(80, 6, 'Nome', 1, 0, 'C', 1);
            $this->Cell(40, 6, 'Valor (Akz)', 1, 0, 'C', 1);
            $this->Cell(40, 6, 'Código', 1, 0, 'C', 1);
            $this->Ln();

            $this->SetFont('helvetica', 'B', 16);
            $this->Cell(190, 6, "Sem dados para apresentar", 1, 0, 'C', 0);
        } else {


            $this->SetFont('helvetica', 10);
            $this->writeHTML("Queiram transferir da nossa conta n.º $conta, domiciliada no  vosso banco o montante de" . "<br/>");
            $this->writeHTML(" Kz $ttotal" . " (" . $this->valorPorExtenso((double) $totalpag, false, false) . " Kwanzas) a título de subsídio. " . "<br/>");
            $this->writeHTML("" . "<br/>");

            $this->SetFont('helvetica', '', 10);
            $this->Ln(4);
            $this->SetFont('helvetica', 'B', 10);


            $this->SetFillColor(199, 196, 186);
            $this->Cell(10, 6, '#', 1, 0, 'C', 1);
            $this->Cell(20, 6, 'Nº.Mec.', 1, 0, 'C', 1);
            $this->Cell(60, 6, 'Nome', 1, 0, 'C', 1);
            $this->Cell(40, 6, 'Valor (Akz)', 1, 0, 'C', 1);
            $this->Cell(50, 6, 'Código', 1, 0, 'C', 1);
            $this->Ln();

            $this->SetFont('helvetica', '', 10);


            $stilo = array(
                'position' => '',
                'align' => 'C',
                'stretch' => false,
                'fitwidth' => true,
                'cellfitalign' => '',
                'border' => false, //true ->adiciona borda
                'hpadding' => 'auto',
                'vpadding' => 'auto',
                'fgcolor' => array(0, 0, 0),
                'bgcolor' => false, //array(255,255,255),
                'text' => false,
                'font' => 'helvetica',
                'fontsize' => 8,
                'stretchtext' => 4
            );

            $contP = 0;
            foreach ($lista as $vector) {
                $contP++;

                if ($contP % 2 == 0) {
                    $this->SetFillColor(248, 248, 248);
                } else {
                    $this->SetFillColor(255, 255, 255);
                }
                $this->Cell(10, 18, $contP, 1, 0, 'C', 0);
                $this->Cell(20, 18, $this->abreviaNomes($vector['Mec']), 1, 0, 'L', 1);
                $this->Cell(60, 18, $this->abreviaNomes($vector['NomeDele']), 1, 0, 'L', 1);
                $this->Cell(40, 18, number_format($vector['massa'], 2, ',', '.'), 1, 0, 'L', 1);
                $this->write1DBarcode($vector['codex'], 'C39', '', '', 50, 16, 0.4, $stilo, 'M');

                $this->Ln();
            }
        }
    }

    public function ordemTransfDesvincPP($lista, $conta = null) {
        $this->SetY(55);
        $this->Ln(8);

        $this->SetFont('helvetica', 9);
        $w = array(10, 20, 60, 70, 50, 90, 30, 30);
        $totalpag = 0;
        foreach ($lista as $vector) {
            $totalpag = $totalpag + $vector['val'];
        }

        $ttotal = (string) number_format($totalpag, 2, ',', '.');


        $this->writeHTML("AO" . "<BR/>");
        $this->writeHTML("BANCO DE POUPANÇA E CRÉDITO" . "<BR/>");
        $this->writeHTML("Luanda, " . $this->retornaDataPortugues(date('Y-m-d')));
        $this->Ln(12);
        $this->SetFont('helvetica', 'B', 12);
        $this->Cell(190, 6, 'ASSUNTO: TRANSFERÊNCIA DE VALORES ', 0, 0, 'L', 0);
        $this->Ln(12);

        if ($ttotal <= 0) {
            $this->SetFont('helvetica', 10);
            $this->writeHTML("Queiram transferir da nossa conta n.º $conta, domiciliada no  vosso banco o montante de" . "<br/>");
            $this->writeHTML(" Kz 0,00 " . " (0 Kwanzas) a título de subsídio. " . "<br/>");
            $this->writeHTML("" . "<br/>");

            $this->SetFont('helvetica', '', 10);
            $this->Ln(4);
            $this->SetFont('helvetica', 'B', 10);


            $this->Ln(2);

            $this->SetFillColor(199, 196, 186);
            $this->Cell(10, 6, '#', 1, 0, 'C', 1);
            $this->Cell(20, 6, 'Nº.Mec.', 1, 0, 'C', 1);
            $this->Cell(80, 6, 'Nome', 1, 0, 'C', 1);
            $this->Cell(40, 6, 'Valor (Akz)', 1, 0, 'C', 1);
            $this->Cell(40, 6, 'Código', 1, 0, 'C', 1);
            $this->Ln();

            $this->SetFont('helvetica', 'B', 16);
            $this->Cell(190, 6, "Sem dados para apresentar", 1, 0, 'C', 0);
        } else {


            $this->SetFont('helvetica', 10);
            $this->writeHTML("Queiram transferir da nossa conta n.º $conta, domiciliada no  vosso banco o montante de" . "<br/>");
            $this->writeHTML(" Kz $ttotal" . " (" . $this->valorPorExtenso((double) $totalpag, false, false) . " Kwanzas) a título de desvinculação no plano de pensões. " . "<br/>");
            $this->writeHTML("" . "<br/>");

            $this->SetFont('helvetica', '', 10);
            $this->Ln(4);
            $this->SetFont('helvetica', 'B', 10);


            $this->SetFillColor(199, 196, 186);
            $this->Cell(10, 6, '#', 1, 0, 'C', 1);
            $this->Cell(20, 6, 'Nº.Mec.', 1, 0, 'C', 1);
            $this->Cell(60, 6, 'Nome', 1, 0, 'C', 1);
            $this->Cell(40, 6, 'Valor (Akz)', 1, 0, 'C', 1);
            $this->Cell(50, 6, 'Código', 1, 0, 'C', 1);
            $this->Ln();

            $this->SetFont('helvetica', '', 10);


            $stilo = array(
                'position' => '',
                'align' => 'C',
                'stretch' => false,
                'fitwidth' => true,
                'cellfitalign' => '',
                'border' => false, //true ->adiciona borda
                'hpadding' => 'auto',
                'vpadding' => 'auto',
                'fgcolor' => array(0, 0, 0),
                'bgcolor' => false, //array(255,255,255),
                'text' => false,
                'font' => 'helvetica',
                'fontsize' => 8,
                'stretchtext' => 4
            );

            $contP = 0;
            foreach ($lista as $vector) {
                $contP++;

                if ($contP % 2 == 0) {
                    $this->SetFillColor(248, 248, 248);
                } else {
                    $this->SetFillColor(255, 255, 255);
                }
                $this->Cell(10, 18, $contP, 1, 0, 'C', 0);
                $this->Cell(20, 18, $this->abreviaNomes($vector['nMec']), 1, 0, 'L', 1);
                $this->Cell(60, 18, $this->abreviaNomes($vector['nomeDele']), 1, 0, 'L', 1);
                $this->Cell(40, 18, number_format($vector['val'], 2, ',', '.'), 1, 0, 'L', 1);
                $this->write1DBarcode($vector['ide'], 'C39', '', '', 50, 16, 0.4, $stilo, 'M');

                $this->Ln();
            }
        }
    }

    public function printCorpoTabelaAmortizacao($tabela) {
        $this->SetY(55);
        $this->Ln(15);
        $this->SetFont('times', 9);
        $tabela = '' . $tabela . '';
        $this->writeHTML($tabela . $this->Ln(8), TRUE, FALSE, FALSE, FALSE, 'J');
        $this->Ln(15);
    }

    public function amort($valortotal = 0, $taxa = 0, $anos = 0) {
        $this->valortotal = $valortotal;
        $this->taxa = $taxa;
        $this->anos = $anos;
        if ($valortotal * $taxa * $anos > 0) {
            $this->npmts = $anos * 12;
            $this->mtaxa = ($taxa / $valortotal);
            $this->pmnt = $valortotal * ($this->mtaxa / (1 - pow(1 + $this->mtaxa, -$this->npmts)));
            $this->tpmnt = $this->pmnt * $this->npmts;
            $this->tint = $this->tpmnt - $valortotal;
        } else {
            $this->pmnt = 0;
            $this->npmts = 0;
            $this->mtaxa = 0;
            $this->tpmnt = 0;
            $this->tint = 0;
        }
    }

    public function payment() {
        return sprintf("%01.5f", $this->pmnt);
    }

    public function totpayment() {
        return sprintf("%01.5f", $this->tpmnt);
    }

    public function totinterest() {
        return sprintf("%01.5f", $this->tint);
    }

    function showTable($show = true, $processo, $taxa, $nome, $tipocredito) {
        $this->Ln(55);
        $this->SetFont('helvetica', 'B', 12);
        $this->Cell(190, 6, 'Tabela de Amortização de Empréstimo', 1, 0, 'C', 0);


        $this->Ln(16);
        $this->SetFillColor(199, 196, 186);
        $this->SetFont('helvetica', 'B', 10);
        $this->Cell(25, 6, 'Processo', 1, 0, 'C', 1);
        $this->Cell(65, 6, 'Associado', 1, 0, 'L', 1);
        $this->Cell(45, 6, 'Tipo de Crédito', 1, 0, 'L', 1);
        $this->Cell(55, 6, 'Taxa de Juros', 1, 0, 'C', 1);
        $this->Ln();

        $this->SetFont('helvetica', '', 10);
        $this->Cell(25, 6, $processo, 1, 0, 'C', 0);
        $this->Cell(65, 6, strtoupper($nome), 1, 0, 'L', 0);
        $this->Cell(45, 6, ucwords($tipocredito), 1, 0, 'L', 0);
        $this->Cell(55, 6, $taxa . '%', 1, 0, 'C', 0);

        $this->Ln(25);
        if ($show) {
            $this->SetFont('helvetica', 'B', 10);
            $w = array(16, 54, 50, 50, 70, 30, 30);

            $this->SetFillColor(199, 196, 186);
            $this->SetTextColor(0); //Cor preta para o texto


            $this->Cell($w[0], 6, 'Mês', 1, 0, 'L', 1);
            $this->Cell($w[1], 6, 'Dívida no Início do mês', 1, 0, 'L', 1);
            // $this->Cell($w[2], 6, 'Prest. Mensal', 1, 0, 'L', 0);
            $this->Cell($w[3], 6, 'Prestação Mensal', 1, 0, 'L', 1);
            $this->Cell($w[4], 6, 'Dívida no Final do mês', 1, 0, 'L', 1);
            //$this->Cell($w[5], 6, 'ddd3', 1, 0, 'L', 0);
            //$this->Cell($w[6], 6, 'ddd4', 1, 0, 'L', 0);
            $this->Ln(6);

            $ebal = $this->valortotal;
            $ccint = 0.0;
            $cpmnt = 0.0;
            $this->SetFont('helvetica', '', 9);
            $fill = 1;



            for ($pnum = 1; $pnum <= $this->npmts; $pnum++) {

                if ($pnum % 2 == 0) {
                    $this->SetFillColor(248, 248, 248);
                } else {
                    $this->SetFillColor(255, 255, 255);
                }
                $this->Cell($w[0], 6, $pnum, 1, 0, 'L', $fill);

                $bbal = $ebal;
                $this->Cell($w[1], 6, number_format($bbal, 2, ',', '.'), 1, 0, 'L', $fill);

                $ipmnt = $bbal * $this->mtaxa;
                //$this->Cell($w[2], 6, number_format($ipmnt, 2, ',', '.'), 1, 0, 'L', $fill);

                $ppmnt = $this->pmnt - $ipmnt;
                $this->Cell($w[3], 6, number_format($ppmnt, 2, ',', '.'), 1, 0, 'L', $fill);

                $ebal = $bbal - $ppmnt;
                $this->Cell($w[4], 6, number_format($ebal, 2, ',', '.'), 1, 0, 'L', $fill);

                $ccint = $ccint + $ipmnt;
                //$this->Cell($w[5], 6, number_format($ccint, 2, ',', '.'), 1, 0, 'L', $fill);

                $cpmnt = $cpmnt + $this->pmnt;
                //$this->Cell($w[6], 6, number_format($cpmnt, 2, ',', '.'), 1, 0, 'L', $fill);

                $this->Ln();
            }
        }
    }

    public function abreviaNomes($nome, $max = 34) {
        $nome = trim($nome);
        $tamanho = strlen($nome);
        if ($tamanho > $max) {
            $nomes = split(" ", $nome);
            $ultimo = array_pop($nomes);
            $nomes = array_reverse($nomes);
            $pri = array_pop($nomes);
            $nomes = array_reverse($nomes);

            $tamanho = strlen($pri) + strlen($ultimo) + 1;
            $nomes_abreviados = "";

            foreach ($nomes as $n) {
                $tm = strlen($n) + $tamanho + 1;
                if (($tm) <= $max) {
                    $nomes_abreviados.=' ' . $n;
                    $tamanho += strlen($n);
                } else {
                    $nomes_abreviados.=' ' . substr($n, 0, 1) . '.';
                    $tamanho+=3;
                }
            }

            $nome_abrev = $pri . " " . $nomes_abreviados . " " . $ultimo;
        } else {
            $nome_abrev = $nome;
        }
        return trim($nome_abrev);
    }

    public function valorPorExtenso($valor = 0, $bolExibirMoeda = true, $bolPalavraFeminina = false) {

        $valor = self::removerFormatacaoNumero($valor);

        $singular = null;
        $plural = null;

        if ($bolExibirMoeda) {
            $singular = array("centavo", "real", "mil", "milhão", "bilhão", "trilhão", "quatrilhão");
            $plural = array("centavos", "reais", "mil", "milhões", "bilhões", "trilhões", "quatrilhões");
        } else {
            $singular = array("", "", "mil", "milhão", "bilhão", "trilhão", "quatrilhão");
            $plural = array("", "", "mil", "milhões", "bilhões", "trilhões", "quatrilhões");
        }

        $c = array("", "cem", "duzentos", "trezentos", "quatrocentos", "quinhentos", "seiscentos", "setecentos", "oitocentos", "novecentos");
        $d = array("", "dez", "vinte", "trinta", "quarenta", "cinquenta", "sessenta", "setenta", "oitenta", "noventa");
        $d10 = array("dez", "onze", "doze", "treze", "quatorze", "quinze", "dezesseis", "dezesete", "dezoito", "dezenove");
        $u = array("", "um", "dois", "três", "quatro", "cinco", "seis", "sete", "oito", "nove");


        if ($bolPalavraFeminina) {

            if ($valor == 1) {
                $u = array("", "uma", "duas", "três", "quatro", "cinco", "seis", "sete", "oito", "nove");
            } else {
                $u = array("", "um", "duas", "três", "quatro", "cinco", "seis", "sete", "oito", "nove");
            }


            $c = array("", "cem", "duzentas", "trezentas", "quatrocentas", "quinhentas", "seiscentas", "setecentas", "oitocentas", "novecentas");
        }


        $z = 0;

        $valor = number_format($valor, 2, ".", ".");
        $inteiro = explode(".", $valor);

        for ($i = 0; $i < count($inteiro); $i++) {
            for ($ii = mb_strlen($inteiro[$i]); $ii < 3; $ii++) {
                $inteiro[$i] = "0" . $inteiro[$i];
            }
        }

        // $fim identifica onde que deve se dar junção de centenas por "e" ou por "," ;)
        $rt = null;
        $fim = count($inteiro) - ($inteiro[count($inteiro) - 1] > 0 ? 1 : 2);
        for ($i = 0; $i < count($inteiro); $i++) {
            $valor = $inteiro[$i];
            $rc = (($valor > 100) && ($valor < 200)) ? "cento" : $c[$valor[0]];
            $rd = ($valor[1] < 2) ? "" : $d[$valor[1]];
            $ru = ($valor > 0) ? (($valor[1] == 1) ? $d10[$valor[2]] : $u[$valor[2]]) : "";

            $r = $rc . (($rc && ($rd || $ru)) ? " e " : "") . $rd . (($rd && $ru) ? " e " : "") . $ru;
            $t = count($inteiro) - 1 - $i;
            $r .= $r ? " " . ($valor > 1 ? $plural[$t] : $singular[$t]) : "";
            if ($valor == "000")
                $z++;
            elseif ($z > 0)
                $z--;

            if (($t == 1) && ($z > 0) && ($inteiro[0] > 0))
                $r .= ( ($z > 1) ? " de " : "") . $plural[$t];

            if ($r)
                $rt = $rt . ((($i > 0) && ($i <= $fim) && ($inteiro[0] > 0) && ($z < 1)) ? ( ($i < $fim) ? ", " : " e ") : " ") . $r;
        }

        $rt = mb_substr($rt, 1);

        return(ucfirst($rt) ? ucfirst(trim($rt)) : "zero");
    }

    public function retornaDataPortugues($data) {

        $ano = substr($data, 0, 4);
        $mes = substr($data, 5, 2);
        $dia = substr($data, 8, 8);

        switch ($mes) {
            case "01": $mes = "Janeiro";
                break;
            case "02": $mes = "Fevereiro";
                break;
            case "03": $mes = "Março";
                break;
            case "04": $mes = "Abril";
                break;
            case "05": $mes = "Maio";
                break;
            case "06": $mes = "Junho";
                break;
            case "07": $mes = "Julho";
                break;
            case "08": $mes = "Agosto";
                break;
            case "09": $mes = "Setembro";
                break;
            case "10": $mes = "Outubro";
                break;
            case "11": $mes = "Novembro";
                break;
            case "12": $mes = "Dezembro";
                break;
        }

        return $dia . " de " . $mes . " de " . $ano;
    }

    public static function removerFormatacaoNumero($strNumero) {

        $strNumero = trim(str_replace("R$", null, $strNumero));

        $vetVirgula = explode(",", $strNumero);
        if (count($vetVirgula) == 1) {
            $acentos = array(".");
            $resultado = str_replace($acentos, "", $strNumero);
            return $resultado;
        } else if (count($vetVirgula) != 2) {
            return $strNumero;
        }

        $strNumero = $vetVirgula[0];
        $strDecimal = mb_substr($vetVirgula[1], 0, 2);

        $acentos = array(".");
        $resultado = str_replace($acentos, "", $strNumero);
        $resultado = $resultado . "." . $strDecimal;

        return $resultado;
    }

    public function Footer() {


        $this->SetY(-15);
        $this->SetFont('helvetica', 'BI', 8);
        $this->Cell(190, 0, '_________________________________________________________________________________________________________________________', 0, 1, 'C', 0);

        $this->Cell(45, 5, 'Processado por Computador', 0, false, 'L', 0, '', 0, false, 'T', 'M');
        //$this->Cell(0, 10, 'Usoko - Associação Mutualista', 0, false, 'L', 0, '', 0, false, 'T', 'M');
        $this->Cell(45, 5, 'cpppn@gmail.com', 0, false, 'L', 0, '', 0, false, 'T', 'M');
        $this->Cell(45, 5, 'Utilizador:AAAA', 0, false, 'L', 0, '', 0, false, 'T', 'M');

        $this->Cell(55, 5, "Data da Impressão " . date('d/m/Y H:i'), 0, false, 'R', 0, '', 0, false, 'T', 'M');
    }

    /////////////////////////////////////
    public function calAmort($p, $iy, $ny, $tt = null, $associado = null, $tipocredito = null, $processo = null) {
        $newbal;
        $im = ($iy / 12) / 100;
        $nm = $ny * 12;

        //$mp, $ip, $pp;
        $i;
        $wala = 0;
        $mp = $p * $im * pow(1 + $im, (double) $nm) / ( pow(1 + $im, (double) $nm) - 1);
        $this->printHeader($associado, $tipocredito, $processo, $iy);

        for ($i = 1; $i < $nm; $i++) {
            $ip = $p * $im; //
            $wala = $wala + $ip;
            $pp = $mp - $ip; //
            $newbal = $p - $pp; //novo saldo                
            $this->printSch($i, $p, $mp, $ip, $pp, $newbal);
            $p = $newbal;  //actualiza o saldo antigo
        }
        //Ultimo mes
        $pp = $p;
        $ip = $p * $im;
        $mp = $pp + $ip;
        $newbal = 0.0;
        $this->printSch($i, $p, $mp, $ip, $pp, $newbal);
        $this->Ln(9);
        $wala = $wala + $ip;
        $this->Cell(190, 6, "Total a pagar: " . number_format($wala, 2, ',', '.'), 1, 0, 'R', 0);
    }

    public function printSch($i, $p, $mp, $ip, $pp, $newbal) {

        $this->Cell(25, 6, $i, 1, 0, 'L', 0);
        $this->Cell(40, 6, number_format($p, 2, ',', '.'), 1, 0, 'L', 0);
        $this->Cell(25, 6, number_format($mp, 2, ',', '.'), 1, 0, 'L', 0);
        $this->Cell(25, 6, number_format($ip, 2, ',', '.'), 1, 0, 'L', 0);
        $this->Cell(25, 6, number_format($pp, 2, ',', '.'), 1, 0, 'L', 0);
        $this->Cell(40, 6, number_format($newbal, 2, ',', '.'), 1, 0, 'L', 0);
        $this->Ln();
    }

    public function printHeader($nomeassociado, $tipocredito, $processo, $taxa) {


        $this->Ln(55);
        $this->SetFont('helvetica', 'B', 12);
        $this->Cell(190, 6, 'Tabela de Amortização de Empréstimo', 1, 0, 'C', 0);


        $this->Ln(16);
        $this->SetFillColor(199, 196, 186);
        $this->SetFont('helvetica', 'B', 10);
        $this->Cell(25, 6, 'Processo', 1, 0, 'C', 1);
        $this->Cell(65, 6, 'Associado', 1, 0, 'L', 1);
        $this->Cell(50, 6, 'Tipo de Crédito', 1, 0, 'L', 1);
        $this->Cell(40, 6, 'Taxa de Juros', 1, 0, 'C', 1);
        $this->Ln();

        $this->SetFont('helvetica', '', 10);
        $this->Cell(25, 6, "$processo", 1, 0, 'C', 0);
        $this->Cell(65, 6, "$nomeassociado", 1, 0, 'L', 0);
        $this->Cell(50, 6, "$tipocredito", 1, 0, 'L', 0);
        $this->Cell(40, 6, "$taxa" . '%', 1, 0, 'C', 0);


        $this->Ln(10);
        $this->SetFont('helvetica', 'B', 10);
        $this->Cell(25, 6, 'Mês', 1, 0, 'C', 0);
        $this->Cell(40, 6, 'Início do mês', 1, 0, 'L', 0);
        $this->Cell(25, 6, 'Amortização', 1, 0, 'L', 0);
        $this->Cell(25, 6, 'Juros', 1, 0, 'L', 0);
        $this->Cell(25, 6, 'Principle paid', 1, 0, 'L', 0);
        $this->Cell(40, 6, 'Dívida no fim do mês', 1, 0, 'L', 0);
        $this->Ln(8);
        $this->SetFont('helvetica', '', 10);
        //echo("\n%-8s%-12s%-10s%-10s%-10s%-12s", " ", "Old", "Monthly", "Interest", "Principle", "New", "Balance");
        //echo("\n%-8s%-12s%-10s%-10s%-10s%-12s\n\n", "Month", "Balance", "Payment", "Paid", "Paid", "Balance");
    }

}
