<?php

namespace Usoko\SIGBundle\General;

use \TCPDF;

class NasaPdf extends TCPDF {

    protected $valortotal;   //valortotal 
    protected $taxa;         //percentagem ou taxa de juros
    protected $anos;         //número de anos a amortizar o crédito
    protected $npmts;        //número de pagamentos 
    protected $mtaxa;        //mensal pagamento com taxa
    protected $tpmnt;        //total valortotal 
    protected $tint;         //total interest paid on the loan
    protected $pmnt;
    protected $obj;

    public function __construct($obj, $valortotal=null, $taxa=null, $anos=null) {

        $this->valortotal = $valortotal;
        $this->taxa = $taxa;
        $this->anos = $anos;
        $this->obj = $obj;
        parent::__construct($orientation = 'P', $unit = 'mm', $format = 'A4', $unicode = true, $encoding = 'UTF-8', $diskcache = false, $pdfa = false);

        $this->AddPage();
		$this->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
    }

    public function Header() {
        //$em = $this->getDoctrine()->getManager();
        $image_file = K_PATH_IMAGES . 'logo.png';
        $this->Image($image_file, 96, 10, 17, '', 'png', '', 'T', false, 300, '', false, false, 0, false, false, false);
        $this->Ln(15);
		
        //$universidade = $em->getRepository('NeutrinoGACBundle:Pessoajuridica')
        //      ->findOneBy(array('tipojuridica' => VarsGeneral::CONS_PESSOA_JURIDICA_UNIVERSIDADE));

        $texto1 = utf8_encode(utf8_decode('República de Angola'));
        $texto2 = utf8_encode(utf8_decode('Usoko - Associação Mutualista'));
        $texto3 = utf8_encode(utf8_decode('***************************'));
        $this->Ln(5);
        $this->SetFont('times', 'B', 12);
		$this->SetFont('helvetica', 'B', 12);
        $this->Cell(0, 10, $texto1, 0, false, 'C', 0, '', 0, false, 'T', 'M');
        $this->Ln(5);
        $this->Cell(0, 10, $texto2, 0, false, 'C', 0, '', 0, false, 'T', 'M');
        $this->Ln(5);
        $this->Cell(0, 10, $texto3, 0, false, 'C', 0, '', 0, false, 'T', 'M');
        $this->Ln(18);
        $texto = '<b></b>';
        $this->SetFont('times', 9);
		$this->SetFont('helvetica', '', 9);
        $texto = '<u>' . $texto . '</u>';
        $this->writeHTML($texto . $this->Ln(8), TRUE, FALSE, FALSE, FALSE, 'C');
        $this->Ln(5);
    }

    public function corpoQuota($lista,$inicio,$fim,$nomeassociado) {
        $this->SetY(55);
        $this->Ln(15);
		$this->Ln(5);
        
        $this->SetFont('times', 9);
        $w = array(60, 60, 70, 50, 70, 30, 30);
		 
		$this->SetFont('helvetica', 'B', 12);
		$this->Cell(190, 6, 'Extracto dos Pagamentos de Quota', 1, 0, 'C', 0);
		$this->Ln(12);
		$this->SetFont('helvetica', '', 10);
		$this->writeHTML("Vimos por este meio apresentar à V/Excia.(s) ". '<b>'." $nomeassociado ".'</b>'." , o extracto dos pagamentos da conta da Usoko, 
		
		da qual é tem feito pagamentos de quotas , para os movimentos efectuados no período de ".$inicio." à ".$fim.".", TRUE, FALSE, FALSE, FALSE, 'J');
		$this->Ln(8);
		
		if(!$lista){
		$this->Ln(2);
		$this->SetFont('helvetica', 'B', 10);
		$this->Cell($w[0], 6, 'Valor (Akz)', 1, 0, 'C', 0);
        $this->Cell($w[1], 6, 'Mês-Ano referente', 1, 0, 'C', 0);
        $this->Cell($w[2], 6, 'Data de Pagamento', 1, 0, 'C', 0);
		$this->Ln();
		
		$this->SetFont('helvetica', 'B', 16);
		$this->Cell(190, 6,"Sem dados para apresentar", 1, 0, 'C', 0);
		}
		else{
		$this->Ln(2);
		$this->SetFont('helvetica', 'B', 10);
		$this->Cell($w[0], 6, 'Valor (Akz)', 1, 0, 'C', 0);
        $this->Cell($w[1], 6, 'Mês-Ano referente', 1, 0, 'C', 0);
        $this->Cell($w[2], 6, 'Data de Pagamento', 1, 0, 'C', 0);
		$this->Ln();
		
		  $this->SetFont('helvetica', '', 10);
		

			
		foreach($lista as $vector){
		$this->Cell($w[0], 6, number_format($vector->getValor(),2,',','.'), 1, 0, 'C', 0);
		$this->Cell($w[1], 6, $vector->getMesAno(), 1, 0, 'C', 0);
		$this->Cell($w[2], 6, $vector->getDataActual()->format('d/m/Y'), 1, 0, 'C', 0);
		$this->Ln();
		}
		}
		
		
       
    }
	
	
	 public function corpoCredito($lista,$inicio,$fim,$nomeassociado) {
	 
        $this->SetY(55);
        $this->Ln(15);
		$this->Ln(5);
        
        $this->SetFont('times', 9);
        $w = array(60, 60, 70, 50, 70, 30, 30);
		 
		$this->SetFont('helvetica', 'B', 12);
		$this->Cell(190, 6, 'Extracto dos Pagamentos de Crédito', 1, 0, 'C', 0);
		$this->Ln(12);
		$this->SetFont('helvetica', '', 10);
		$this->writeHTML("Vimos por este meio apresentar à V/Excia.(s) ". '<b>'." $nomeassociado ".'</b>'." , o extracto dos pagamentos da conta da Usoko, 
		
		da qual é tem feito pagamentos de créditos , para os movimentos efectuados no período de ".$inicio." à ".$fim.".", TRUE, FALSE, FALSE, FALSE, 'J');
		$this->Ln(8);
		
		if(!$lista){
		$this->Ln(2);
		$this->SetFont('helvetica', 'B', 10);
		$this->Cell($w[0], 6, 'Valor (Akz)', 1, 0, 'C', 0);
        $this->Cell($w[1], 6, 'Mês-Ano referente', 1, 0, 'C', 0);
        $this->Cell($w[2], 6, 'Data de Pagamento', 1, 0, 'C', 0);
		$this->Ln();
		
		$this->SetFont('helvetica', 'B', 16);
		$this->Cell(190, 6,"Sem dados para apresentar", 1, 0, 'C', 0);
		}
		else{
		$this->Ln(2);
		$this->SetFont('helvetica', 'B', 10);
		$this->Cell($w[0], 6, 'Valor (Akz)', 1, 0, 'C', 0);
        $this->Cell($w[1], 6, 'Mês-Ano referente', 1, 0, 'C', 0);
        $this->Cell($w[2], 6, 'Data de Pagamento', 1, 0, 'C', 0);
		$this->Ln();
		
		  $this->SetFont('helvetica', '', 10);
		

			
		foreach($lista as $vector){
		$this->Cell($w[0], 6, number_format($vector->getValor(),2,',','.'), 1, 0, 'C', 0);
		$this->Cell($w[1], 6, $vector->getMesAno(), 1, 0, 'C', 0);
		$this->Cell($w[2], 6, $vector->getDataActual()->format('d/m/Y'), 1, 0, 'C', 0);
		$this->Ln();
		}
		}
       
    }
	
public function corpoPlano($lista,$inicio,$fim,$nomeassociado) {
        $this->SetY(55);
        $this->Ln(15);
		$this->Ln(5);
        
        $this->SetFont('times', 9);
        $w = array(60, 60, 70, 50, 70, 30, 30);
		 
		$this->SetFont('helvetica', 'B', 12);
		$this->Cell(190, 6, 'Extracto dos Pagamentos do Plano de Pensões ', 1, 0, 'C', 0);
		$this->Ln(12);
		$this->SetFont('helvetica', '', 10);
		$this->writeHTML("Vimos por este meio apresentar à V/Excia.(s) ". '<b>'." $nomeassociado ".'</b>'." , o extracto dos pagamentos da conta da Usoko, 
		
		da qual é tem feito pagamentos para o plano de pensões, para os movimentos efectuados no período de ".$inicio." à ".$fim.".", TRUE, FALSE, FALSE, FALSE, 'J');
		$this->Ln(8);
		
		if(!$lista){
		$this->Ln(2);
		$this->SetFont('helvetica', 'B', 10);
		$this->Cell($w[0], 6, 'Valor (Akz)', 1, 0, 'C', 0);
        $this->Cell($w[1], 6, 'Mês-Ano referente', 1, 0, 'C', 0);
        $this->Cell($w[2], 6, 'Data de Pagamento', 1, 0, 'C', 0);
		$this->Ln();
		
		$this->SetFont('helvetica', 'B', 16);
		$this->Cell(190, 6,"Sem dados para apresentar", 1, 0, 'C', 0);
		}
		else{
		$this->Ln(2);
		$this->SetFont('helvetica', 'B', 10);
		$this->Cell($w[0], 6, 'Valor (Akz)', 1, 0, 'C', 0);
        $this->Cell($w[1], 6, 'Mês-Ano referente', 1, 0, 'C', 0);
        $this->Cell($w[2], 6, 'Data de Pagamento', 1, 0, 'C', 0);
		$this->Ln();
		
		  $this->SetFont('helvetica', '', 10);
		

			
		foreach($lista as $vector){
		$this->Cell($w[0], 6, number_format($vector->getValor(),2,',','.'), 1, 0, 'C', 0);
		$this->Cell($w[1], 6, $vector->getMesAno(), 1, 0, 'C', 0);
		$this->Cell($w[2], 6, $vector->getDataActual()->format('d/m/Y'), 1, 0, 'C', 0);
		$this->Ln();
		}
		}
       
       
    }
	
	
	public function corpoRelatorioInfraccao($lista) {
        $this->SetY(55);
        $this->Ln(15);
		$this->Ln(5);
        
        $this->SetFont('times', 9);
        $w = array(10,80, 70, 30, 50, 70, 30, 30);
		 
		$this->SetFont('helvetica', 'B', 12);
		$this->Cell(190, 6, 'Relatório dos Associados Infraccionados ', 1, 0, 'C', 0);
		$this->Ln(12);
		$this->SetFont('helvetica', '', 10);
		
		$this->Ln(8);
		
		$this->Ln(2);
		$this->SetFont('helvetica', 'B', 10);
		
		$this->Cell($w[0], 6, '#', 1, 0, 'C', 0);
		$this->Cell($w[1], 6, 'Nome Completo', 1, 0, 'C', 0);
        $this->Cell($w[2], 6, 'Infracção', 1, 0, 'C', 0);
        $this->Cell($w[3], 6, 'Quantidade', 1, 0, 'C', 0);
		$this->Ln();
		
		  $this->SetFont('helvetica', '', 10);
		 
		$contP=0;	
		foreach($lista as $vector){
		$contP++;
		$this->Cell($w[0], 6,$contP , 1, 0, 'C', 0);
		$this->Cell($w[1], 6,$vector['nome'], 1, 0, 'C', 0);
		$this->Cell($w[2], 6,$vector['infra'], 1, 0, 'C', 0);
		$this->Cell($w[3], 6,$vector['qtd'], 1, 0, 'C', 0);
		$this->Ln();
		}
       
    }

	
	
		public function corpoRelatorioPagamento($lista,$data1,$data2) {
        $this->SetY(55);
        $this->Ln(15);
		$this->Ln(5);
        
        $this->SetFont('times', 9);
        $w = array(10,35, 75, 45, 50, 70, 30, 30);
		 
		$this->SetFont('helvetica', 'B', 12);
		$this->Cell(190, 6, 'Relatório dos Pagamentos dos Associados ', 1, 0, 'C', 0);
		$this->Ln(12);
		$this->SetFont('helvetica', '', 10);
		
		$this->Ln(8);
		
		$this->Ln(2);
		$this->SetFont('helvetica', 'B', 10);
		
		$this->Cell($w[0], 6, '#', 1, 0, 'C', 0);
		$this->Cell($w[1], 6, 'Nº. Mecanográfico', 1, 0, 'C', 0);
        $this->Cell($w[2], 6, 'Nome Completo', 1, 0, 'C', 0);
		$this->Cell($w[1], 6, 'Contribuição', 1, 0, 'C', 0);
        $this->Cell($w[1], 6, 'Valor Pago(Akz)', 1, 0, 'C', 0);
		$this->Ln();
		
		  $this->SetFont('helvetica', '', 10);
		 
		$contP=0;	
		foreach($lista as $vector){
		$contP++;
		$this->Cell($w[0], 6,$contP , 1, 0, 'C', 0);
		$this->Cell($w[1], 6, $vector['meca'], 1, 0, 'L', 0);
		$this->Cell($w[2], 6, $vector['nome'], 1, 0, 'L', 0);
		$this->Cell($w[1], 6, $vector['tipos'], 1, 0, 'L', 0);
		$this->Cell($w[1], 6, number_format($vector['total'],2,',','.'), 1, 0, 'L', 0);
		$this->Ln();
		}
       
    }
	
	public function corpoRelatorioComparticipacao($lista,$data1,$data2) {
        $this->SetY(55);
        $this->Ln(15);
		$this->Ln(5);
        
        $this->SetFont('times', 9);
        $w = array(10,20, 60, 70, 50, 70, 30, 30);
		 
		$this->SetFont('helvetica', 'B', 12);
		$this->Cell(190, 6, 'Relatório das Comparticipações dos Associados ', 1, 0, 'C', 0);
		$this->Ln(12);
		$this->SetFont('helvetica', '', 10);
		
		$this->Ln(8);
		
		$this->Ln(2);
		$this->SetFont('helvetica', 'B', 10);
		
		$this->Cell($w[0], 6, '#', 1, 0, 'C', 0);
		$this->Cell($w[1], 6, 'Nº. Mecan.', 1, 0, 'C', 0);
        $this->Cell($w[2], 6, 'Nome Completo', 1, 0, 'C', 0);
		$this->Cell($w[3], 6, 'Subsídio', 1, 0, 'C', 0);
        $this->Cell($w[7], 6, 'Valor Pago(Akz)', 1, 0, 'C', 0);
		$this->Ln();
		
		  $this->SetFont('helvetica', '', 10);
		 
		$contP=0;	
		foreach($lista as $vector){
		$contP++;
		$this->Cell($w[0], 6,$contP , 1, 0, 'C', 0);
		$this->Cell($w[1], 6, $vector['nMecanografico'], 1, 0, 'L', 0);
		$this->Cell($w[2], 6, $vector['nome'], 1, 0, 'L', 0);
		$this->Cell($w[3], 6, $this->abreviaNomes($vector['subs'],30), 1, 0, 'L', 0);
		$this->Cell($w[7], 6, number_format($vector['total'],2,',','.'), 1, 0, 'L', 0);
		$this->Ln();
		}
       
    }
	
	
	
	public function corpoRelatorioSubsidio($lista,$data1,$data2) {
        $this->SetY(55);
        $this->Ln(15);
		$this->Ln(5);
        
        $this->SetFont('times', 9);
        $w = array(10,20, 60, 70, 50, 90, 30, 30);
		 
		$this->SetFont('helvetica', 'B', 12);
		$this->Cell(190, 6, 'Relatório dos valores acumulados por subsídio ', 1, 0, 'C', 0);
		$this->Ln(12);
		$this->SetFont('helvetica', '', 10);
		
		$this->Ln(8);
		
		$this->Ln(2);
		$this->SetFont('helvetica', 'B', 10);
		
		$this->Cell(10, 6, '#', 1, 0, 'C', 0);
		$this->Cell(100, 6, 'Tipo de Subsídio', 1, 0, 'C', 0);
        $this->Cell(80, 6, 'Valor acumulado (Akz)', 1, 0, 'C', 0);
        $this->Ln();
		
		  $this->SetFont('helvetica', '', 10);
		 
		$contP=0;	
		foreach($lista as $vector){
		$contP++;
		$this->Cell(10, 6,$contP , 1, 0, 'C', 0);
		$this->Cell(100, 6, $this->abreviaNomes($vector['tipo']), 1, 0, 'L', 0);
		$this->Cell(80, 6, number_format($vector['valor'],2,',','.'), 1, 0, 'L', 0);
		
		$this->Ln();
		}
       
    }

    public function printCorpoTabelaAmortizacao($tabela) {
        $this->SetY(55);
        $this->Ln(15);
        $this->SetFont('times', 9);
        $tabela = '' . $tabela . '';
        $this->writeHTML($tabela . $this->Ln(8), TRUE, FALSE, FALSE, FALSE, 'J');
        $this->Ln(15);
    }

    public function amort($valortotal = 0, $taxa = 0, $anos = 0) {
        $this->valortotal = $valortotal;   
        $this->taxa = $taxa;       
        $this->anos = $anos;     
        if ($valortotal * $taxa * $anos > 0) {
            $this->npmts = $anos * 12;  
            $this->mtaxa = ($taxa /$valortotal); 
            $this->pmnt = $valortotal * ($this->mtaxa / (1 - pow(1 + $this->mtaxa, -$this->npmts))); 
            $this->tpmnt = $this->pmnt * $this->npmts;  
            $this->tint = $this->tpmnt - $valortotal;         
        } else {
            $this->pmnt = 0;
            $this->npmts = 0;
            $this->mtaxa = 0;
            $this->tpmnt = 0;
            $this->tint = 0;
        }
    }

    public function payment() {
        return sprintf("%01.5f", $this->pmnt);
    }

    public function totpayment() {
        return sprintf("%01.5f", $this->tpmnt);
    }

    public function totinterest() {
        return sprintf("%01.5f", $this->tint);
    }

    function showTable($show = true,$processo,$taxa,$nome,$tipocredito) {
        $this->Ln(55);
        $this->SetFont('helvetica', 'B', 12);
        $this->Cell(190, 6, 'Tabela de Amortização de Empréstimo', 1, 0, 'C', 0);
        
        
        $this->Ln(16);
        $this->SetFont('helvetica', 'B', 10);
        $this->Cell(25, 6, 'Processo', 1, 0, 'C', 0);
        $this->Cell(65, 6, 'Associado', 1, 0, 'L', 0);
        $this->Cell(45, 6, 'Tipo de Crédito', 1, 0, 'L', 0);
        $this->Cell(55, 6, 'Taxa de Juros', 1, 0, 'C', 0);
        $this->Ln();
        
        $this->SetFont('helvetica', '', 10);
        $this->Cell(25, 6, $processo, 1, 0, 'C', 0);
        $this->Cell(65, 6, strtoupper($nome), 1, 0, 'L', 0);
        $this->Cell(45, 6, ucwords($tipocredito), 1, 0, 'L', 0);
        $this->Cell(55, 6, $taxa.'%', 1, 0, 'C', 0);
        
        $this->Ln(25);
        if ($show) {
            $this->SetFont('helvetica', 'B', 10);
            $w = array(16, 54, 50, 50, 70, 30, 30);
			
            $this->Cell($w[0], 6, 'Mês', 1, 0, 'L', 0);
            $this->Cell($w[1], 6, 'Dívida no Início do mês', 1, 0, 'L', 0);
         // $this->Cell($w[2], 6, 'Prest. Mensal', 1, 0, 'L', 0);
            $this->Cell($w[3], 6, 'Prestação Mensal', 1, 0, 'L', 0);
            $this->Cell($w[4], 6, 'Dívida no Final do mês', 1, 0, 'L', 0);
          //$this->Cell($w[5], 6, 'ddd3', 1, 0, 'L', 0);
          //$this->Cell($w[6], 6, 'ddd4', 1, 0, 'L', 0);
            $this->Ln(6);

            $ebal = $this->valortotal;
            $ccint = 0.0;
            $cpmnt = 0.0;
            $this->SetFont('helvetica', '', 9);
            $fill = 0;
            
            
           
            
            
            for ($pnum = 1; $pnum <= $this->npmts; $pnum++) {
                
				//$this->SetDrawColor(128, 0, 0);
				$this->SetFillColor(224, 235, 255);	
                //$this->SetFillColor(255, 255, 255);
				
				$this->Cell($w[0], 6, $pnum, 1, 0, 'L', $fill);

                $bbal = $ebal;
                $this->Cell($w[1], 6, number_format($bbal, 2, ',', '.'), 1, 0, 'L', $fill);

                $ipmnt = $bbal * $this->mtaxa;
                //$this->Cell($w[2], 6, number_format($ipmnt, 2, ',', '.'), 1, 0, 'L', $fill);

                $ppmnt = $this->pmnt - $ipmnt ;
                $this->Cell($w[3], 6, number_format($ppmnt, 2, ',', '.'), 1, 0, 'L', $fill);

                $ebal = $bbal - $ppmnt;
                $this->Cell($w[4], 6, number_format($ebal, 2, ',', '.'), 1, 0, 'L', $fill);

                $ccint = $ccint + $ipmnt;
                //$this->Cell($w[5], 6, number_format($ccint, 2, ',', '.'), 1, 0, 'L', $fill);

                $cpmnt = $cpmnt + $this->pmnt;
                //$this->Cell($w[6], 6, number_format($cpmnt, 2, ',', '.'), 1, 0, 'L', $fill);

                $this->Ln();
				$this->SetFillColor(224, 235, 255);
            }
        }
    }

	
	    public function abreviaNomes($nome, $max = 34) {
        $nome = trim($nome);
        $tamanho = strlen($nome);
        if ($tamanho > $max) {
            $nomes = split(" ", $nome);
            $ultimo = array_pop($nomes);
            $nomes = array_reverse($nomes);
            $pri = array_pop($nomes);
            $nomes = array_reverse($nomes);

            $tamanho = strlen($pri) + strlen($ultimo) + 1;
            $nomes_abreviados = "";

            foreach ($nomes as $n) {
                $tm = strlen($n) + $tamanho + 1;
                if (($tm) <= $max) {
                    $nomes_abreviados.=' ' . $n;
                    $tamanho += strlen($n);
                } else {
                    $nomes_abreviados.=' ' . substr($n, 0, 1) . '.';
                    $tamanho+=3;
                }
            }

            $nome_abrev = $pri . " " . $nomes_abreviados . " " . $ultimo;
        } else {
            $nome_abrev = $nome;
        }
        return trim($nome_abrev);
    }
	
    public function Footer() {


        $this->SetY(-15);
        $this->SetFont('helvetica', 'BI', 8);

        $this->Cell(0, 10, 'Usoko - Associação Mutualista', 0, false, 'L', 0, '', 0, false, 'T', 'M');
    }

}
