CHANGELOG for 2.5.x
===================

This changelog references the relevant changes (bug and security fixes) done
in 2.5 minor versions.

To get the diff for a specific change, go to https://github.com/symfony/symfony/commit/XXX where XXX is the change hash
To get the diff between two versions, go to https://github.com/symfony/symfony/compare/v2.5.0...v2.5.1

* 2.5.4 (2014-09-03)

 * security #11832 CVE-2014-6072 (fabpot)
 * security #11831 CVE-2014-5245 (stof)
 * security #11830 CVE-2014-4931 (aitboudad, Jérémy Derussé)
 * security #11829 CVE-2014-6061 (damz, fabpot)
 * security #11828 CVE-2014-5244 (nicolas-grekas, larowlan)
 * bug #10197 [FrameworkBundle] PhpExtractor bugfix and improvements (mtibben)
 * bug #11772 [Filesystem] Add FTP stream wrapper context option to enable overwrite (Damian Sromek)
 * bug #11791 [Process] fix mustRun() in sigchild environments (xabbuh)
 * bug #11788 [Yaml] fixed mapping keys containing a quoted # (hvt, fabpot)
 * bug #11787 fixed DateComparator if file does not exist (avi123)
 * bug #11160 [DoctrineBridge] Abstract Doctrine Subscribers with tags (merk)
 * bug #11768 [ClassLoader] Add a __call() method to XcacheClassLoader (tstoeckler)
 * bug #11739 [Validator] Pass strict argument into the strict email validator (brianfreytag)
 * bug #11749 [TwigBundle] Remove hard dependency of RequestContext in AssetsExtension (pgodel)
 * bug #11726 [Filesystem Component] mkdir race condition fix #11626 (kcassam)
 * bug #11677 [YAML] resolve variables in inlined YAML (xabbuh)
 * bug #11639 [DependencyInjection] Fixed factory service not within the ServiceReferenceGraph. (boekkooi)
 * bug #11778 [Validator] Fixed wrong translations for Collection constraints (samicemalone)
 * bug #11756 [DependencyInjection] fix @return anno created by PhpDumper (jakubkulhan)
 * bug #11711 [DoctrineBridge] Fix empty parameter logging in the dbal logger (jakzal)
 * bug #11692 [DomCrawler] check for the correct field type (xabbuh)
 * bug #11672 [Routing] fix handling of nullable XML attributes (xabbuh)
 * bug #11624 [DomCrawler] fix the axes handling in a bc way (xabbuh)
 * bug #11676 [Form] Fixed #11675 ValueToDuplicatesTransformer accept "0" value (Nek-)
 * bug #11695 [Validators] Fixed failing tests requiring ICU 52.1 which are skipped otherwise (webmozart)
 * bug #11584 [FrameworkBundle] Fixed validator factory definition when the Validator API is "auto" for PHP < 5.3.9 (webmozart)
 * bug #11645 [Form] Fixed ValidatorExtension to work with the 2.5 Validation API (webmozart)
 * bug #11529 [WebProfilerBundle] Fixed double height of canvas (hason)
 * bug #11666 [DIC] Fixed: anonymous services are always private (lyrixx)
 * bug #11641 [WebProfilerBundle ] Fix toolbar vertical alignment (blaugueux)
 * bug #11637 fix dependencies on HttpFoundation component (xabbuh)
 * bug #11559 [Validator] Convert objects to string in comparison validators (webmozart)
 * feature #11510 [HttpFoundation] MongoDbSessionHandler supports auto expiry via configurable expiry_field (catchamonkey)
 * bug #11408 [HttpFoundation] Update QUERY_STRING when overrideGlobals (yguedidi)
 * bug #11625 [FrameworkBundle] resolve parameters before the configs are processed in the config:debug command (xabbuh)
 * bug #11633 [FrameworkBundle] add missing attribute to XSD (xabbuh)
 * bug #11601 [Validator] Allow basic auth in url when using UrlValidator. (blaugueux)
 * bug #11609 [Console] fixed style creation when providing an unknown tag option (fabpot)
 * bug #10914 [HttpKernel] added an analyze of environment parameters for built-in server (mauchede)
 * bug #11598 [Finder] Shell escape and windows support (Gordon Franke, gimler)
 * bug #11582 [DoctrineBridge] Changed UniqueEntityValidator to use the 2.5 Validation API (webmozart)

* 2.5.3 (2014-08-06)

 * bug #11571 [Form] Fixed FormValidator compatibility with the non-BC 2.5 Validation API (webmozart)
 * bug #11499 [BrowserKit] Fixed relative redirects for ambiguous paths (pkruithof)
 * bug #11516 [BrowserKit] Fix browser kit redirect with ports (dakota)
 * bug #11545 [Bundle][FrameworkBundle] built-in server: exit when docroot does not exist (xabbuh)
 * bug #11560 Plural fix (1emming)
 * bug #11558 [DependencyInjection] Fixed missing 'factory-class' attribute in XmlDumper output (kerdany)
 * bug #11498 [Validator] Made it possible (again) to pass a class name to validatePropertyValue() (webmozart)
 * bug #11548 [Component][DomCrawler] fix axes handling in Crawler::filterXPath() (xabbuh)
 * bug #11422 [DependencyInjection] Self-referenced 'service_container' service breaks garbage collection (sun)
 * bug #11428 [Serializer] properly handle null data when denormalizing (xabbuh)
 * bug #10687 [Validator] Fixed string conversion in constraint violations (eagleoneraptor, webmozart)
 * bug #11412 [Validator] Made sure that context changes don't leak out of (Contextual)ValidatorInterface (webmozart)
 * bug #11475 [EventDispatcher] don't count empty listeners (xabbuh)
 * bug #11436 fix signal handling in wait() on calls to stop() (xabbuh, romainneutron)
 * bug #11469  [BrowserKit] Fixed server HTTP_HOST port uri conversion (bcremer, fabpot)
 * bug #11425 Fix issue described in #11421 (Ben, ben-rosio)
 * bug #11423 Pass a Scope instance instead of a scope name when cloning a container in the GrahpvizDumper (jakzal)
 * bug #11448 [MonologBridge] fixed Console handler priorities (fabpot)
 * bug #11454 [Validator] Fixed memory leak in ValidatorBuilder (webmozart)
 * bug #11120 [Process] Reduce I/O load on Windows platform (romainneutron)
 * bug #11370 [FrameworkBundle] avoid raising unexpected RuntimeException when specifying $_SERVER['KERNEL_DIR'] (iteman)
 * bug #11342 [Form] Check if IntlDateFormatter constructor returned a valid object before using it (romainneutron)
 * bug #11439 [ExpressionLanguage] Fixed double quoted string literals containing sharps (pylebecq)
 * bug #11410 [Validator] Fixed object initializers in 2.5 version of the Validator (webmozart)
 * bug #11411 [Validator] Backported #11410 to 2.3: Object initializers are called only once per object (webmozart)
 * bug #11403 [Translator][FrameworkBundle] Added @ to the list of allowed chars in Translator (takeit)
 * bug #11381  [Process] Use correct test for empty string in UnixPipes (whs, romainneutron)

* 2.5.2 (2014-07-15)

 * [Security] Forced validate of locales passed to the translator
 * bug #11350 [Form] solved dependency to ValidatorInterface, fix #11036 (Sebastian Blum)
 * bug #11278 Remove Spaceless Blocks From Twig Templates (chrisguitarguy)
 * feature #11367 [HttpFoundation] Fix to prevent magic bytes injection in JSONP responses... (CVE-2014-4671) (Andrew Moore)
 * bug #11284 [Console] Remove estimated field from debug_nomax (bburnichon)
 * bug #11386 Remove Spaceless Blocks from Twig Form Templates (chrisguitarguy)
 * bug #9719 [TwigBundle] fix configuration tree for paths (mdavis1982, cordoval)
 * bug #11244 [HttpFoundation] Remove body-related headers when sending the response, if body is empty (SimonSimCity)

* 2.5.1 (2014-07-08)

 * bug #11283 [SecurityBundle] Remove Expression Language services when the component is unavailable (thewilkybarkid)
 * bug #11238 [Translation] Added unescaping of ids in PoFileLoader (JustBlackBird)
 * bug #11194 [DomCrawler] Remove the query string and the anchor of the uri of a link (benja-M-1)
 * bug #11272 [Console] Make sure formatter is the same. (akimsko)
 * bug #11259 [Config] Fixed failed config schema loads due to libxml_disable_entity_loader usage (ccorliss)
 * bug #11234 [ClassLoader] fixed PHP warning on PHP 5.3 (fabpot)
 * bug #11179 [Process] Fix ExecutableFinder with open basedir (cs278)
 * bug #11242 [CssSelector] Refactored the CssSelector to remove the circular object graph (stof)
 * bug #11219 [DomCrawler] properly handle buttons with single and double quotes insid... (xabbuh)
 * bug #11220 [Components][Serializer] optional constructor arguments can be omitted during the denormalization process (xabbuh)
 * bug #11186 Added missing `break` statement (apfelbox)
 * bug #11168 [YAML] fix merge node (<<) (Tobion)
 * bug #11170 [Console] Fixed notice in QuestionHelper (florianv)
 * bug #11169 [Console] Fixed notice in DialogHelper (florianv)
 * bug #11144 [HttpFoundation] Fixed Request::getPort returns incorrect value under IPv6 (kicken)
 * bug #11121 [Process] Do not redirect output to file handles when output is disabled, simply discard it (romainneutron)
 * bug #10966 PHP Fatal error when getContainer method of ContainerAwareCommand has be... (kevinvergauwen)
 * bug #10981 [HttpFoundation] Fixed isSecure() check to be compliant with the docs (Jannik Zschiesche)
 * bug #11117 [Validator] Fix array notation in the PropertyPath::append() (jakzal)
 * bug #11113 [HttpKernel] Fix event dispatcher dependency (hacfi)
 * bug #11111 Fixed undefined ImageValidator::$suffices property when uploading an image during functional tests (OwlyCode)
 * bug #11099 [Debug] work-around https://bugs.php.net/61272 (nicolas-grekas)
 * bug #11092 [HttpFoundation] Fix basic authentication in url with PHP-FPM (Kdecherf)
 * bug #11097 [Debug] simplify code path to remove potential blank pages (nicolas-grekas)
 * bug #10808 [DomCrawler] Empty select with attribute name="foo[]" bug fix (darles)
 * bug #11063 [HttpFoundation] fix switch statement (Tobion)
 * bug #11054 [Serializer] Xml encoder whitespace fix (fieg)
 * bug #11009 [HttpFoundation] smaller fixes for PdoSessionHandler (Tobion)
 * bug #11047 #10862 loadClassMetadata vs loadValidatorMetadata: revert default config (phramz)
 * bug #11042 [Debug] fix debug handlers config (nicolas-grekas)
 * bug #11043 [Console] OutputFormatter Unset Bold has wrong id (DZunke)
 * bug #11033 [Debug] fix wrong case mismatch exception (nicolas-grekas)
 * bug #11044 [Serializer] Fix BC break since 2.5 (fieg)
 * bug #11041 Remove undefined variable $e (skydiablo)

* 2.5.0 (2014-05-31)

 * bug #11014 [Validator] Remove property and method targets from the optional and required constraints (jakzal)
 * bug #10983 [DomCrawler] Fixed charset detection in html5 meta charset tag (77web)

* 2.5.0-RC1 (2014-05-28)

 * bug #10979 Make rootPath part of regex greedy (artursvonda)
 * bug #10995 [TwigBridge][Trans]set %count% only on transChoice from the current context. (aitboudad)
 * bug #10989 [Debug] throw even in stacking mode to preserve code paths (nicolas-grekas)
 * bug #10987 [DomCrawler] Fixed a forgotten case of complex XPath queries (stof)
 * feature #10930 [Process] Deprecate using values that are not string for Process::setStdin and ProcessBuilder::setInput (romainneutron)
 * bug #10971 [Process] Fix conflicts between latest 2.3 fix and 2.5 deprecation (romainneutron)
 * feature #10932 [Process] Deprecate Process::setStdin in favor of Process::setInput (romainneutron)
 * bug #10849 [WIP][Finder] Fix wrong implementation on sortable callback comparator (ProPheT777)
 * bug #10929 [Process] Add validation on Process input (romainneutron)
 * bug #10946 [PropertyAccess] Fixed getValue() when accessing non-existing indices of ArrayAccess implementations (webmozart)
 * bug #10958 [DomCrawler] Fixed filterXPath() chaining loosing the parent DOM nodes (stof, robbertkl)
 * bug #10953 [HttpKernel] fixed file uploads in functional tests without file selected (realmfoo)
 * feature #10941 [Debug] cleanup interfaces before 2.5-final (nicolas-grekas)
 * bug #10947 [PropertyAccess] Fixed getValue() when accessing non-existing indices of ArrayAccess implementations (webmozart)
 * bug #10937 [HttpKernel] Fix "absolute path" when we look to the cache directory (BenoitLeveque)
 * bug #10933 Changed the default value of checkbox and radio to match the HTML spec (stof)
 * bug #10927 [DomCrawler] Changed typehints form DomNode to DomElement (stof)
 * bug #10894 [HttpKernel] removed absolute paths from the generated container (fabpot)
 * bug #10926 [DomCrawler] Fixed the initial state for options without value attribute (stof)
 * bug #10925 [DomCrawler] Fixed the handling of boolean attributes in ChoiceFormField (stof)
 * feature #10882 Fix issue #10867 (umpirsky)
 * bug #10902 [Yaml] Fixed YAML Parser does not ignore duplicate keys, violating YAML spec. (sun)
 * feature #10912 [Form] Added support for injecting HttpFoundation's Request in ServerParams for the Validator extension (csarrazi)
 * bug #10777 [Form] Automatically add step attribute to HTML5 time widgets to display seconds if needed (tucksaun)
 * bug #10909 [PropertyAccess] Fixed plurals for -ves words (csarrazi)
 * bug #10904 [HttpKernel] Replace sha1 with sha256 in recently added tests (jakzal)
 * bug #10899 Explicitly define the encoding. (jakzal)
 * bug #10897 [Console] Fix a console test (jakzal)
 * bug #10896 [HttpKernel] Fixed cache behavior when TTL has expired and a default "global" TTL is defined (alquerci, fabpot)
 * bug #10841 [DomCrawler] Fixed image input case sensitive (geoffrey-brier)
 * bug #10714 [Console]Improve formatter for double-width character (denkiryokuhatsuden)
 * bug #10872 [Form] Fixed TrimListenerTest as of PHP 5.5 (webmozart)
 * feature #10880 [DependencyInjection] GraphvizDumper now displays unresolved parameters (rosstuck)
 * bug #10876 [Console] Make `Helper\Table::setStyle()` chainable again (stloyd)
 * bug #10762 [BrowserKit] Allow URLs that don't contain a path when creating a cookie from a string (thewilkybarkid)
 * bug #10861 [Debug] enhance perf of DebugClassLoader (nicolas-grekas)
 * bug #10863 [Security] Add check for supported attributes in AclVoter (artursvonda)
 * bug #10854 [Debug] fix handling deprecated warnings and stacked errors turned into exceptions (nicolas-grekas)
 * feature #10843 [TwigBridge] Added compile-time issues checking in twig:lint command (maxromanovsky)
 * feature #10829 Fix issue 9172 (umpirsky)
 * bug #10833 [TwigBridge][Transchoice] set %count% from the current context. (aitboudad)
 * bug #10820 [WebProfilerBundle] Fixed profiler seach/homepage with empty token (tucksaun)
 * bug #10809 Fixed composer to include config component for mocks in phpunit (jpauli)
 * bug #10815 Fixed issue #5427 (umpirsky)
 * bug #10817 [Debug] fix #10313: FlattenException not found (nicolas-grekas)

* 2.5.0-BETA2 (2014-04-29)

 * bug #10803 [Debug] fix ErrorHandlerTest when context is not an array (nicolas-grekas)
 * bug #10801 [Debug] ErrorHandler: remove $GLOBALS from context in PHP5.3 fix #10292 (nicolas-grekas)
 * bug #10799 [Debug] less intrusive work around for https://bugs.php.net/54275 (nicolas-grekas)
 * bug #10797 [HttpFoundation] Allow File instance to be passed to BinaryFileResponse (anlutro)
 * bug #10798 [Console] Fix #10795: Allow instancing Console Application when STDIN is not declared (romainneutron)
 * bug #10643 [TwigBridge] Removed strict check when found variables inside a translation (goetas)
 * bug #10605 [ExpressionLanguage] Strict in_array check in Parser.php (parnas)
 * bug #10789 [Console] Fixed the rendering of exceptions on HHVM with a terminal width (stof)
 * bug #10773 [WebProfilerBundle ] Fixed an edge case on WDT loading (tucksaun)
 * feature #10786 [FrameworkBundle] removed support for HHVM built-in web server as it is deprecated now (fabpot)
 * bug #10784 [Security] removed $csrfTokenManager type hint from SimpleFormAuthenticationListener constructor argument (choonge)
 * bug #10776 [Debug] fix #10771 DebugClassLoader can't load PSR4 libs (nicolas-grekas)
 * bug #10763 [Process] Disable TTY mode on Windows platform (romainneutron)
 * bug #10772 [Finder] Fix ignoring of unreadable dirs in the RecursiveDirectoryIterator (jakzal)
 * bug #10757 [Process] Setting STDIN while running should not be possible (romainneutron)
 * bug #10749 Fixed incompatibility of x509 auth with nginx (alcaeus)
 * feature #10725 [Debug] Handled errors (nicolas-grekas)
 * bug #10735 [Translation] [PluralizationRules] Little correction for case 'ar' (klyk50)
 * bug #10720 [HttpFoundation] Fix DbalSessionHandler  (Tobion)
 * bug #10721 [HttpFoundation] status 201 is allowed to have a body (Tobion)
 * bug #10728 [Process] Fix #10681, process are failing on Windows Server 2003 (romainneutron)
 * bug #10733 [DomCrawler] Textarea value should default to empty string instead of null. (Berdir)
 * bug #10723 [Security] fix DBAL connection typehint (Tobion)
 * bug #10715 [Debug] Fixed ClassNotFoundFatalErrorHandler on windows. (lyrixx)
 * bug #10700 Fixes various inconsistencies in the code (fabpot)
 * bug #10697 [Translation] Make IcuDatFileLoader/IcuResFileLoader::load invalid resource compatible with HHVM. (idn2104)

* 2.5.0-BETA1 (2014-04-11)

 * first beta release

