<?php

namespace Usoko\SIGBundle\Entity;
use Symfony\Component\Security\Core\Role\RoleInterface;
use Doctrine\ORM\Mapping as ORM;

/**
 * Funcao
 *
 * @ORM\Table(name="funcao", uniqueConstraints={@ORM\UniqueConstraint(name="nome_UNIQUE", columns={"nome"})})
 * @ORM\Entity
 */
class Funcao implements RoleInterface {

    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $id;

    /**
     * @var string
     *
     * @ORM\Column(name="nome", type="string", length=60, nullable=false)
     */
    private $nome;

    /**
     * @var string
     *
     * @ORM\Column(name="role", type="string", length=60, nullable=false)
     */
    private $role;

    /**
     * @var \Doctrine\Common\Collections\Collection
     *
     * @ORM\ManyToMany(targetEntity="Utilizador", mappedBy="funcao")
     */
    private $utilizador;

    /**
     * Constructor
     */
    public function __construct() {
        $this->utilizador = new \Doctrine\Common\Collections\ArrayCollection();
    }

    /**
     * Get id
     *
     * @return integer 
     */
    public function getId() {
        return $this->id;
    }

    /**
     * Set nome
     *
     * @param string $nome
     * @return Funcao
     */
    public function setNome($nome) {
        $this->nome = $nome;

        return $this;
    }

    /**
     * Get nome
     *
     * @return string 
     */
    public function getNome() {
        return $this->nome;
    }

    /**
     * Set role
     *
     * @param string $role
     * @return Funcao
     */
    public function setRole($role) {
        $this->role = $role;

        return $this;
    }

    

    /**
     * Add utilizador
     *
     * @param \Usoko\SIGBundle\Entity\Utilizador $utilizador
     * @return Funcao
     */
    public function addUtilizador(\Usoko\SIGBundle\Entity\Utilizador $utilizador) {
        $this->utilizador[] = $utilizador;

        return $this;
    }

    /**
     * Remove utilizador
     *
     * @param \Usoko\SIGBundle\Entity\Utilizador $utilizador
     */
    public function removeUtilizador(\Usoko\SIGBundle\Entity\Utilizador $utilizador) {
        $this->utilizador->removeElement($utilizador);
    }

    /**
     * Get utilizador
     *
     * @return \Doctrine\Common\Collections\Collection 
     */
    public function getUtilizador() {
        return $this->utilizador;
    }

    public function getRole() {
        return $this->role;
    }

}
